/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.i18n.AbstractLocaleResolver;

public class AcceptHeaderLocaleResolver
extends AbstractLocaleResolver {
    private final List<Locale> supportedLocales = new ArrayList<Locale>(4);

    public void setSupportedLocales(List<Locale> locales) {
        this.supportedLocales.clear();
        this.supportedLocales.addAll(locales);
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null && request.getHeader("Accept-Language") == null) {
            return defaultLocale;
        }
        Locale requestLocale = request.getLocale();
        List<Locale> supportedLocales = this.getSupportedLocales();
        if (supportedLocales.isEmpty() || supportedLocales.contains(requestLocale)) {
            return requestLocale;
        }
        Locale supportedLocale = this.findSupportedLocale(request, supportedLocales);
        if (supportedLocale != null) {
            return supportedLocale;
        }
        return defaultLocale != null ? defaultLocale : requestLocale;
    }

    private @Nullable Locale findSupportedLocale(HttpServletRequest request, List<Locale> supportedLocales) {
        Enumeration requestLocales = request.getLocales();
        Locale languageMatch = null;
        block0: while (requestLocales.hasMoreElements()) {
            Locale locale = (Locale)requestLocales.nextElement();
            if (supportedLocales.contains(locale)) {
                if (languageMatch != null && !languageMatch.getLanguage().equals(locale.getLanguage())) continue;
                return locale;
            }
            if (languageMatch != null) continue;
            for (Locale supportedLocale : supportedLocales) {
                if (StringUtils.hasLength((String)supportedLocale.getCountry()) || !supportedLocale.getLanguage().equals(locale.getLanguage())) continue;
                languageMatch = supportedLocale;
                continue block0;
            }
        }
        return languageMatch;
    }

    @Override
    public void setLocale(HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable Locale locale) {
        throw new UnsupportedOperationException("Cannot change HTTP Accept-Language header - use a different locale resolution strategy");
    }
}

