/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public abstract class WebContentGenerator
extends WebApplicationObjectSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    private static final String HEADER_PRAGMA = "Pragma";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private Set<String> supportedMethods;
    private boolean requireSession = false;
    private boolean useExpiresHeader = true;
    private boolean useCacheControlHeader = true;
    private boolean useCacheControlNoStore = true;
    private int cacheSeconds = -1;

    public WebContentGenerator() {
        this(true);
    }

    public WebContentGenerator(boolean restrictDefaultSupportedMethods) {
        if (restrictDefaultSupportedMethods) {
            this.supportedMethods = new HashSet<String>(4);
            this.supportedMethods.add(METHOD_GET);
            this.supportedMethods.add(METHOD_HEAD);
            this.supportedMethods.add(METHOD_POST);
        }
    }

    public final void setSupportedMethods(String[] methods) {
        this.supportedMethods = methods != null ? new HashSet<String>((Collection)Arrays.asList(methods)) : null;
    }

    public final String[] getSupportedMethods() {
        return StringUtils.toStringArray(this.supportedMethods);
    }

    public final void setRequireSession(boolean requireSession) {
        this.requireSession = requireSession;
    }

    public final boolean isRequireSession() {
        return this.requireSession;
    }

    public final void setUseExpiresHeader(boolean useExpiresHeader) {
        this.useExpiresHeader = useExpiresHeader;
    }

    public final boolean isUseExpiresHeader() {
        return this.useExpiresHeader;
    }

    public final void setUseCacheControlHeader(boolean useCacheControlHeader) {
        this.useCacheControlHeader = useCacheControlHeader;
    }

    public final boolean isUseCacheControlHeader() {
        return this.useCacheControlHeader;
    }

    public final void setUseCacheControlNoStore(boolean useCacheControlNoStore) {
        this.useCacheControlNoStore = useCacheControlNoStore;
    }

    public final boolean isUseCacheControlNoStore() {
        return this.useCacheControlNoStore;
    }

    public final void setCacheSeconds(int seconds) {
        this.cacheSeconds = seconds;
    }

    public final int getCacheSeconds() {
        return this.cacheSeconds;
    }

    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response, boolean lastModified) throws ServletException {
        this.checkAndPrepare(request, response, this.cacheSeconds, lastModified);
    }

    protected final void checkAndPrepare(HttpServletRequest request, HttpServletResponse response, int cacheSeconds, boolean lastModified) throws ServletException {
        String method = request.getMethod();
        if (this.supportedMethods != null && !this.supportedMethods.contains(method)) {
            throw new HttpRequestMethodNotSupportedException(method, StringUtils.toStringArray(this.supportedMethods));
        }
        if (this.requireSession && request.getSession(false) == null) {
            throw new HttpSessionRequiredException("Pre-existing session required but none found");
        }
        this.applyCacheSeconds(response, cacheSeconds, lastModified);
    }

    protected final void preventCaching(HttpServletResponse response) {
        response.setHeader(HEADER_PRAGMA, "no-cache");
        if (this.useExpiresHeader) {
            response.setDateHeader(HEADER_EXPIRES, 1L);
        }
        if (this.useCacheControlHeader) {
            response.setHeader(HEADER_CACHE_CONTROL, "no-cache");
            if (this.useCacheControlNoStore) {
                response.addHeader(HEADER_CACHE_CONTROL, "no-store");
            }
        }
    }

    protected final void cacheForSeconds(HttpServletResponse response, int seconds) {
        this.cacheForSeconds(response, seconds, false);
    }

    protected final void cacheForSeconds(HttpServletResponse response, int seconds, boolean mustRevalidate) {
        if (this.useExpiresHeader) {
            response.setDateHeader(HEADER_EXPIRES, System.currentTimeMillis() + (long)seconds * 1000L);
        }
        if (this.useCacheControlHeader) {
            String headerValue = "max-age=" + seconds;
            if (mustRevalidate) {
                headerValue = String.valueOf(headerValue) + ", must-revalidate";
            }
            response.setHeader(HEADER_CACHE_CONTROL, headerValue);
        }
    }

    protected final void applyCacheSeconds(HttpServletResponse response, int seconds) {
        this.applyCacheSeconds(response, seconds, false);
    }

    protected final void applyCacheSeconds(HttpServletResponse response, int seconds, boolean mustRevalidate) {
        if (seconds > 0) {
            this.cacheForSeconds(response, seconds, mustRevalidate);
        } else if (seconds == 0) {
            this.preventCaching(response);
        }
    }
}

