/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.Event;
import org.springframework.social.facebook.api.EventInvitee;
import org.springframework.social.facebook.api.EventOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.Invitation;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventTemplate
extends AbstractFacebookOperations
implements EventOperations {
    private final GraphApi graphApi;

    public EventTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public PagedList<Invitation> getInvitations() {
        return this.getInvitations("me", 0, 25);
    }

    @Override
    public PagedList<Invitation> getInvitations(int offset, int limit) {
        return this.getInvitations("me", offset, limit);
    }

    @Override
    public PagedList<Invitation> getInvitations(PagingParameters pagedListParameters) {
        return this.getInvitations("me", pagedListParameters);
    }

    @Override
    public PagedList<Invitation> getInvitations(String userId) {
        return this.getInvitations(userId, 0, 25);
    }

    @Override
    public PagedList<Invitation> getInvitations(String userId, int offset, int limit) {
        return this.getInvitations(userId, new PagingParameters(limit, offset, null, null));
    }

    @Override
    public PagedList<Invitation> getInvitations(String userId, PagingParameters pagedListParameters) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagedListUtils.getPagingParameters(pagedListParameters);
        return this.graphApi.fetchConnections(userId, "events", Invitation.class, parameters);
    }

    @Override
    public Event getEvent(String eventId) {
        return this.graphApi.fetchObject(eventId, Event.class);
    }

    @Override
    public byte[] getEventImage(String eventId) {
        return this.getEventImage(eventId, ImageType.NORMAL);
    }

    @Override
    public byte[] getEventImage(String eventId, ImageType imageType) {
        return this.graphApi.fetchImage(eventId, "picture", imageType);
    }

    @Override
    public String createEvent(String name, String startTime, String endTime) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"name", (Object)name);
        data.set((Object)"start_time", (Object)startTime);
        data.set((Object)"end_time", (Object)endTime);
        return this.graphApi.publish("me", "events", (MultiValueMap<String, Object>)data);
    }

    @Override
    public void deleteEvent(String eventId) {
        this.requireAuthorization();
        this.graphApi.delete(eventId);
    }

    @Override
    public void sendInvitation(String eventId, String ... userIds) {
        this.requireAuthorization();
        Assert.notEmpty((Object[])userIds, (String)"At least one user ID must be given when sending an invitation.");
        if (userIds.length == 1) {
            this.graphApi.post(eventId, "invited/" + userIds[0], (MultiValueMap<String, String>)new LinkedMultiValueMap());
        } else {
            LinkedMultiValueMap data = new LinkedMultiValueMap();
            data.set((Object)"users", (Object)this.join(userIds));
            this.graphApi.post(eventId, "invited", (MultiValueMap<String, String>)data);
        }
    }

    private String join(String ... strings) {
        Assert.notEmpty((Object[])strings);
        StringBuilder builder = new StringBuilder();
        builder.append(strings[0]);
        if (strings.length > 1) {
            for (int i = 1; i < strings.length; ++i) {
                builder.append(",").append(strings[i]);
            }
        }
        return builder.toString();
    }

    @Override
    public PagedList<EventInvitee> getInvited(String eventId) {
        return this.graphApi.fetchConnections(eventId, "invited", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<EventInvitee> getAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "attending", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<EventInvitee> getMaybeAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "maybe", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<EventInvitee> getNoReplies(String eventId) {
        return this.graphApi.fetchConnections(eventId, "noreply", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<EventInvitee> getDeclined(String eventId) {
        return this.graphApi.fetchConnections(eventId, "declined", EventInvitee.class, new String[0]);
    }

    @Override
    public void acceptInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "attending", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void maybeInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "maybe", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public void declineInvitation(String eventId) {
        this.requireAuthorization();
        this.graphApi.post(eventId, "declined", (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    @Override
    public PagedList<Event> search(String query) {
        return this.search(query, 0, 25);
    }

    @Override
    public PagedList<Event> search(String query, int offset, int limit) {
        return this.search(query, new PagingParameters(limit, offset, null, null));
    }

    @Override
    public PagedList<Event> search(String query, PagingParameters pagedListParameters) {
        MultiValueMap<String, String> queryMap = PagedListUtils.getPagingParameters(pagedListParameters);
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"event");
        return this.graphApi.fetchConnections("search", null, Event.class, queryMap);
    }
}

