/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.Comment;
import org.springframework.social.facebook.api.CommentOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommentTemplate
extends AbstractFacebookOperations
implements CommentOperations {
    private final GraphApi graphApi;

    public CommentTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public List<Comment> getComments(String objectId) {
        return this.getComments(objectId, 0, 25);
    }

    @Override
    public List<Comment> getComments(String objectId, int offset, int limit) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"offset", (Object)String.valueOf(offset));
        parameters.set((Object)"limit", (Object)String.valueOf(limit));
        return this.graphApi.fetchConnections(objectId, "comments", Comment.class, (MultiValueMap<String, String>)parameters);
    }

    @Override
    public Comment getComment(String commentId) {
        return this.graphApi.fetchObject(commentId, Comment.class);
    }

    @Override
    public String addComment(String objectId, String message) {
        this.requireAuthorization();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(objectId, "comments", (MultiValueMap<String, Object>)map);
    }

    @Override
    public void deleteComment(String objectId) {
        this.requireAuthorization();
        this.graphApi.delete(objectId);
    }

    @Override
    public List<Reference> getLikes(String objectId) {
        return this.graphApi.fetchConnections(objectId, "likes", Reference.class, new String[0]);
    }
}

