/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapAuthority
implements GrantedAuthority {
    private String dn;
    private String role;
    private Map<String, List<String>> attributes;

    public LdapAuthority(String role, String dn) {
        this(role, dn, null);
    }

    public LdapAuthority(String role, String dn, Map<String, List<String>> attributes) {
        Assert.notNull((Object)role, (String)"role can not be null");
        Assert.notNull((Object)dn, (String)"dn can not be null");
        this.role = role;
        this.dn = dn;
        this.attributes = attributes;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public String getDn() {
        return this.dn;
    }

    public List<String> getAttributeValues(String name) {
        List<String> result = null;
        if (this.attributes != null) {
            result = this.attributes.get(name);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public String getFirstAttributeValue(String name) {
        List<String> result = this.getAttributeValues(name);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public String getAuthority() {
        return this.role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LdapAuthority)) {
            return false;
        }
        LdapAuthority that = (LdapAuthority)o;
        if (!this.dn.equals(that.dn)) {
            return false;
        }
        return this.role.equals(that.role);
    }

    public int hashCode() {
        int result = this.dn.hashCode();
        result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LdapAuthority{dn='" + this.dn + '\'' + ", role='" + this.role + '\'' + '}';
    }
}

