/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapServerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String CONTEXT_SOURCE_CLASS = "org.springframework.security.ldap.DefaultSpringSecurityContextSource";
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_URL = "url";
    private static final String ATT_PRINCIPAL = "manager-dn";
    private static final String ATT_PASSWORD = "manager-password";
    public static final String ATT_ROOT_SUFFIX = "root";
    private static final String OPT_DEFAULT_ROOT_SUFFIX = "dc=springframework,dc=org";
    public static final String ATT_LDIF_FILE = "ldif";
    private static final String OPT_DEFAULT_LDIF_FILE = "classpath*:*.ldif";
    public static final String ATT_PORT = "port";
    private static final int DEFAULT_PORT = 33389;
    public static final String OPT_DEFAULT_PORT = String.valueOf(33389);
    private static final String APACHEDS_CLASSNAME = "org.apache.directory.server.core.DefaultDirectoryService";
    private static final String UNBOUNID_CLASSNAME = "com.unboundid.ldap.listener.InMemoryDirectoryServer";
    private static final String APACHEDS_CONTAINER_CLASSNAME = "org.springframework.security.ldap.server.ApacheDSContainer";
    private static final String UNBOUNDID_CONTAINER_CLASSNAME = "org.springframework.security.ldap.server.UnboundIdContainer";

    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        String id;
        RootBeanDefinition contextSource;
        String url = elt.getAttribute(ATT_URL);
        if (!StringUtils.hasText((String)url)) {
            contextSource = this.createEmbeddedServer(elt, parserContext);
        } else {
            contextSource = new RootBeanDefinition();
            contextSource.setBeanClassName(CONTEXT_SOURCE_CLASS);
            contextSource.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)url);
        }
        contextSource.setSource(parserContext.extractSource((Object)elt));
        String managerDn = elt.getAttribute(ATT_PRINCIPAL);
        String managerPassword = elt.getAttribute(ATT_PASSWORD);
        if (StringUtils.hasText((String)managerDn)) {
            if (!StringUtils.hasText((String)managerPassword)) {
                parserContext.getReaderContext().error("You must specify the manager-password if you supply a " + managerDn, (Object)elt);
            }
            contextSource.getPropertyValues().addPropertyValue("userDn", (Object)managerDn);
            contextSource.getPropertyValues().addPropertyValue("password", (Object)managerPassword);
        }
        String contextSourceId = StringUtils.hasText((String)(id = elt.getAttribute("id"))) ? id : "org.springframework.security.securityContextSource";
        parserContext.getRegistry().registerBeanDefinition(contextSourceId, (BeanDefinition)contextSource);
        return null;
    }

    private RootBeanDefinition createEmbeddedServer(Element element, ParserContext parserContext) {
        String beanId;
        String port;
        Object source = parserContext.extractSource((Object)element);
        String suffix = element.getAttribute(ATT_ROOT_SUFFIX);
        if (!StringUtils.hasText((String)suffix)) {
            suffix = OPT_DEFAULT_ROOT_SUFFIX;
        }
        if (!StringUtils.hasText((String)(port = element.getAttribute(ATT_PORT)))) {
            port = this.getDefaultPort();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using default port of " + port));
            }
        }
        String url = "ldap://127.0.0.1:" + port + "/" + suffix;
        BeanDefinitionBuilder contextSource = BeanDefinitionBuilder.rootBeanDefinition((String)CONTEXT_SOURCE_CLASS);
        contextSource.addConstructorArgValue((Object)url);
        contextSource.addPropertyValue("userDn", (Object)"uid=admin,ou=system");
        contextSource.addPropertyValue("password", (Object)"secret");
        String mode = element.getAttribute("mode");
        RootBeanDefinition ldapContainer = this.getRootBeanDefinition(mode);
        ldapContainer.setSource(source);
        ldapContainer.getConstructorArgumentValues().addGenericArgumentValue((Object)suffix);
        String ldifs = element.getAttribute(ATT_LDIF_FILE);
        if (!StringUtils.hasText((String)ldifs)) {
            ldifs = OPT_DEFAULT_LDIF_FILE;
        }
        ldapContainer.getConstructorArgumentValues().addGenericArgumentValue((Object)ldifs);
        ldapContainer.getPropertyValues().addPropertyValue(ATT_PORT, (Object)port);
        this.logger.info((Object)("Embedded LDAP server bean definition created for URL: " + url));
        if (parserContext.getRegistry().containsBeanDefinition("org.springframework.security.apacheDirectoryServerContainer") || parserContext.getRegistry().containsBeanDefinition("org.springframework.security.unboundidServerContainer")) {
            parserContext.getReaderContext().error("Only one embedded server bean is allowed per application context", (Object)element);
        }
        if ((beanId = this.resolveBeanId(mode)) != null) {
            parserContext.getRegistry().registerBeanDefinition(beanId, (BeanDefinition)ldapContainer);
        }
        return (RootBeanDefinition)contextSource.getBeanDefinition();
    }

    private RootBeanDefinition getRootBeanDefinition(String mode) {
        if (this.isApacheDsEnabled(mode)) {
            return new RootBeanDefinition(APACHEDS_CONTAINER_CLASSNAME, null, null);
        }
        if (this.isUnboundidEnabled(mode)) {
            return new RootBeanDefinition(UNBOUNDID_CONTAINER_CLASSNAME, null, null);
        }
        throw new IllegalStateException("Embedded LDAP server is not provided");
    }

    private String resolveBeanId(String mode) {
        if (this.isApacheDsEnabled(mode)) {
            return "org.springframework.security.apacheDirectoryServerContainer";
        }
        if (this.isUnboundidEnabled(mode)) {
            return "org.springframework.security.unboundidServerContainer";
        }
        return null;
    }

    private boolean isApacheDsEnabled(String mode) {
        return "apacheds".equals(mode) || ClassUtils.isPresent((String)APACHEDS_CLASSNAME, (ClassLoader)this.getClass().getClassLoader());
    }

    private boolean isUnboundidEnabled(String mode) {
        return "unboundid".equals(mode) || ClassUtils.isPresent((String)UNBOUNID_CLASSNAME, (ClassLoader)this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultPort() {
        ServerSocket serverSocket = null;
        try {
            try {
                serverSocket = new ServerSocket(33389);
            }
            catch (IOException e) {
                try {
                    serverSocket = new ServerSocket(0);
                }
                catch (IOException e2) {
                    String string = String.valueOf(33389);
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return string;
                }
            }
            String string = String.valueOf(serverSocket.getLocalPort());
            return string;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

