/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.config.http.FormLoginBeanDefinitionParser;
import org.springframework.security.config.http.LogoutBeanDefinitionParser;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.RememberMeBeanDefinitionParser;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.UserDetailsServiceInjectionBeanPostProcessor;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AuthenticationConfigBuilder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_REALM = "realm";
    private static final String DEF_REALM = "Spring Security Application";
    static final String OPEN_ID_AUTHENTICATION_PROCESSING_FILTER_CLASS = "org.springframework.security.openid.OpenIDAuthenticationFilter";
    static final String OPEN_ID_AUTHENTICATION_PROVIDER_CLASS = "org.springframework.security.openid.OpenIDAuthenticationProvider";
    static final String OPEN_ID_CONSUMER_CLASS = "org.springframework.security.openid.OpenID4JavaConsumer";
    static final String OPEN_ID_ATTRIBUTE_CLASS = "org.springframework.security.openid.OpenIDAttribute";
    static final String AUTHENTICATION_PROCESSING_FILTER_CLASS = "org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter";
    private static final String ATT_AUTO_CONFIG = "auto-config";
    private static final String ATT_ACCESS_DENIED_PAGE = "access-denied-page";
    private static final String ATT_ACCESS_DENIED_ERROR_PAGE = "error-page";
    private static final String ATT_ENTRY_POINT_REF = "entry-point-ref";
    private static final String ATT_USER_SERVICE_REF = "user-service-ref";
    private static final String ATT_REF = "ref";
    private Element httpElt;
    private ParserContext pc;
    private final boolean autoConfig;
    private final boolean allowSessionCreation;
    private final String portMapperName;
    private RootBeanDefinition anonymousFilter;
    private BeanReference anonymousProviderRef;
    private BeanDefinition rememberMeFilter;
    private String rememberMeServicesId;
    private BeanReference rememberMeProviderRef;
    private BeanDefinition basicFilter;
    private BeanDefinition basicEntryPoint;
    private RootBeanDefinition formFilter;
    private BeanDefinition formEntryPoint;
    private RootBeanDefinition openIDFilter;
    private BeanDefinition openIDEntryPoint;
    private BeanReference openIDProviderRef;
    private String openIDProviderId;
    private String formFilterId = null;
    private String openIDFilterId = null;
    private BeanDefinition x509Filter;
    private BeanDefinition x509EntryPoint;
    private BeanReference x509ProviderRef;
    private String x509ProviderId;
    private BeanDefinition logoutFilter;
    private BeanDefinition loginPageGenerationFilter;
    private BeanDefinition etf;
    private BeanReference requestCache;
    final SecureRandom random;

    public AuthenticationConfigBuilder(Element element, ParserContext pc, boolean allowSessionCreation, String portMapperName) {
        this.httpElt = element;
        this.pc = pc;
        this.portMapperName = portMapperName;
        this.autoConfig = "true".equals(element.getAttribute(ATT_AUTO_CONFIG));
        this.allowSessionCreation = allowSessionCreation;
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed find SHA1PRNG algorithm!");
        }
    }

    void createRememberMeFilter(BeanReference authenticationManager) {
        String ATT_KEY = "key";
        String DEF_KEY = "SpringSecured";
        Element rememberMeElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"remember-me");
        if (rememberMeElt != null) {
            String key = rememberMeElt.getAttribute("key");
            if (!StringUtils.hasText((String)key)) {
                key = "SpringSecured";
            }
            this.rememberMeFilter = (RootBeanDefinition)new RememberMeBeanDefinitionParser(key).parse(rememberMeElt, this.pc);
            this.rememberMeFilter.getPropertyValues().addPropertyValue("authenticationManager", (Object)authenticationManager);
            this.rememberMeServicesId = ((RuntimeBeanReference)this.rememberMeFilter.getPropertyValues().getPropertyValue("rememberMeServices").getValue()).getBeanName();
            this.createRememberMeProvider(key);
        }
    }

    private void createRememberMeProvider(String key) {
        RootBeanDefinition provider = new RootBeanDefinition(RememberMeAuthenticationProvider.class);
        provider.setSource(this.rememberMeFilter.getSource());
        provider.getPropertyValues().addPropertyValue("key", (Object)key);
        String id = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)provider);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)provider, id));
        this.rememberMeProviderRef = new RuntimeBeanReference(id);
    }

    void createFormLoginFilter(BeanReference sessionStrategy, BeanReference authManager) {
        Element formLoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"form-login");
        if (formLoginElt != null || this.autoConfig) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_security_check", AUTHENTICATION_PROCESSING_FILTER_CLASS, this.requestCache, sessionStrategy);
            parser.parse(formLoginElt, this.pc);
            this.formFilter = parser.getFilterBean();
            this.formEntryPoint = parser.getEntryPointBean();
        }
        if (this.formFilter != null) {
            this.formFilter.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)new Boolean(this.allowSessionCreation));
            this.formFilter.getPropertyValues().addPropertyValue("authenticationManager", (Object)authManager);
            this.formFilterId = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)this.formFilter);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)this.formFilter, this.formFilterId));
            this.injectRememberMeServicesRef(this.formFilter, this.rememberMeServicesId);
        }
    }

    void createOpenIDLoginFilter(BeanReference sessionStrategy, BeanReference authManager) {
        Element openIDLoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"openid-login");
        if (openIDLoginElt != null) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/j_spring_openid_security_check", OPEN_ID_AUTHENTICATION_PROCESSING_FILTER_CLASS, this.requestCache, sessionStrategy);
            parser.parse(openIDLoginElt, this.pc);
            this.openIDFilter = parser.getFilterBean();
            this.openIDEntryPoint = parser.getEntryPointBean();
            Element attrExElt = DomUtils.getChildElementByTagName((Element)openIDLoginElt, (String)"attribute-exchange");
            if (attrExElt != null) {
                BeanDefinitionBuilder consumerBldr = BeanDefinitionBuilder.rootBeanDefinition((String)OPEN_ID_CONSUMER_CLASS);
                ManagedList attributes = new ManagedList();
                for (Element attElt : DomUtils.getChildElementsByTagName((Element)attrExElt, (String)"openid-attribute")) {
                    String name = attElt.getAttribute("name");
                    String type = attElt.getAttribute("type");
                    String required = attElt.getAttribute("required");
                    String count = attElt.getAttribute("count");
                    BeanDefinitionBuilder attrBldr = BeanDefinitionBuilder.rootBeanDefinition((String)OPEN_ID_ATTRIBUTE_CLASS);
                    attrBldr.addConstructorArgValue((Object)name);
                    attrBldr.addConstructorArgValue((Object)type);
                    if (StringUtils.hasLength((String)required)) {
                        attrBldr.addPropertyValue("required", (Object)Boolean.valueOf(required));
                    }
                    if (StringUtils.hasLength((String)count)) {
                        attrBldr.addPropertyValue("count", (Object)Integer.parseInt(count));
                    }
                    attributes.add((Object)attrBldr.getBeanDefinition());
                }
                consumerBldr.addConstructorArgValue((Object)attributes);
                this.openIDFilter.getPropertyValues().addPropertyValue("consumer", (Object)consumerBldr.getBeanDefinition());
            }
        }
        if (this.openIDFilter != null) {
            this.openIDFilter.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)new Boolean(this.allowSessionCreation));
            this.openIDFilter.getPropertyValues().addPropertyValue("authenticationManager", (Object)authManager);
            this.openIDFilterId = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)this.openIDFilter);
            this.pc.getRegistry().registerBeanDefinition(this.openIDFilterId, (BeanDefinition)this.openIDFilter);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)this.openIDFilter, this.openIDFilterId));
            this.injectRememberMeServicesRef(this.openIDFilter, this.rememberMeServicesId);
            this.createOpenIDProvider();
        }
    }

    private void createOpenIDProvider() {
        Element openIDLoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"openid-login");
        BeanDefinitionBuilder openIDProviderBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)OPEN_ID_AUTHENTICATION_PROVIDER_CLASS);
        String userService = openIDLoginElt.getAttribute(ATT_USER_SERVICE_REF);
        if (StringUtils.hasText((String)userService)) {
            openIDProviderBuilder.addPropertyReference("userDetailsService", userService);
        }
        AbstractBeanDefinition openIDProvider = openIDProviderBuilder.getBeanDefinition();
        this.openIDProviderId = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)openIDProvider);
        this.openIDProviderRef = new RuntimeBeanReference(this.openIDProviderId);
    }

    private void injectRememberMeServicesRef(RootBeanDefinition bean, String rememberMeServicesId) {
        if (rememberMeServicesId != null) {
            bean.getPropertyValues().addPropertyValue("rememberMeServices", (Object)new RuntimeBeanReference(rememberMeServicesId));
        }
    }

    void createBasicFilter(BeanReference authManager) {
        Element basicAuthElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"http-basic");
        String realm = this.httpElt.getAttribute(ATT_REALM);
        if (!StringUtils.hasText((String)realm)) {
            realm = DEF_REALM;
        }
        RootBeanDefinition filter = null;
        RootBeanDefinition entryPoint = null;
        if (basicAuthElt != null || this.autoConfig) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(BasicAuthenticationFilter.class);
            entryPoint = new RootBeanDefinition(BasicAuthenticationEntryPoint.class);
            entryPoint.setSource(this.pc.extractSource((Object)this.httpElt));
            entryPoint.getPropertyValues().addPropertyValue("realmName", (Object)realm);
            String entryPointId = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)entryPoint);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)entryPoint, entryPointId));
            filterBuilder.addPropertyValue("authenticationManager", (Object)authManager);
            filterBuilder.addPropertyValue("authenticationEntryPoint", (Object)new RuntimeBeanReference(entryPointId));
            filter = (RootBeanDefinition)filterBuilder.getBeanDefinition();
        }
        this.basicFilter = filter;
        this.basicEntryPoint = entryPoint;
    }

    void createX509Filter(BeanReference authManager) {
        Element x509Elt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"x509");
        RootBeanDefinition filter = null;
        RootBeanDefinition entryPoint = null;
        if (x509Elt != null) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(X509AuthenticationFilter.class);
            filterBuilder.getRawBeanDefinition().setSource(this.pc.extractSource((Object)x509Elt));
            filterBuilder.addPropertyValue("authenticationManager", (Object)authManager);
            String regex = x509Elt.getAttribute("subject-principal-regex");
            if (StringUtils.hasText((String)regex)) {
                BeanDefinitionBuilder extractor = BeanDefinitionBuilder.rootBeanDefinition(SubjectDnX509PrincipalExtractor.class);
                extractor.addPropertyValue("subjectDnRegex", (Object)regex);
                filterBuilder.addPropertyValue("principalExtractor", (Object)extractor.getBeanDefinition());
            }
            filter = (RootBeanDefinition)filterBuilder.getBeanDefinition();
            entryPoint = new RootBeanDefinition(Http403ForbiddenEntryPoint.class);
            entryPoint.setSource(this.pc.extractSource((Object)x509Elt));
            this.createX509Provider();
        }
        this.x509Filter = filter;
        this.x509EntryPoint = entryPoint;
    }

    private void createX509Provider() {
        Element x509Elt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"x509");
        RootBeanDefinition provider = new RootBeanDefinition(PreAuthenticatedAuthenticationProvider.class);
        String userServiceRef = x509Elt.getAttribute(ATT_USER_SERVICE_REF);
        if (StringUtils.hasText((String)userServiceRef)) {
            RootBeanDefinition preAuthUserService = new RootBeanDefinition(UserDetailsByNameServiceWrapper.class);
            preAuthUserService.setSource(this.pc.extractSource((Object)x509Elt));
            preAuthUserService.getPropertyValues().addPropertyValue("userDetailsService", (Object)new RuntimeBeanReference(userServiceRef));
            provider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", (Object)preAuthUserService);
        }
        this.x509ProviderId = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)provider);
        this.x509ProviderRef = new RuntimeBeanReference(this.x509ProviderId);
    }

    void createLoginPageFilterIfNeeded() {
        boolean needLoginPage = this.formFilter != null || this.openIDFilter != null;
        String formLoginPage = this.getLoginFormUrl(this.formEntryPoint);
        String openIDLoginPage = this.getLoginFormUrl(this.openIDEntryPoint);
        if (needLoginPage && formLoginPage == null && openIDLoginPage == null) {
            this.logger.info((Object)"No login page configured. The default internal one will be used. Use the 'login-page' attribute to set the URL of the login page.");
            BeanDefinitionBuilder loginPageFilter = BeanDefinitionBuilder.rootBeanDefinition(DefaultLoginPageGeneratingFilter.class);
            if (this.formFilter != null) {
                loginPageFilter.addConstructorArgReference(this.formFilterId);
            }
            if (this.openIDFilter != null) {
                loginPageFilter.addConstructorArgReference(this.openIDFilterId);
            }
            this.loginPageGenerationFilter = loginPageFilter.getBeanDefinition();
        }
    }

    void createLogoutFilter() {
        Element logoutElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"logout");
        if (logoutElt != null || this.autoConfig) {
            this.logoutFilter = new LogoutBeanDefinitionParser(this.rememberMeServicesId).parse(logoutElt, this.pc);
        }
    }

    void createAnonymousFilter() {
        Element anonymousElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"anonymous");
        if (anonymousElt != null && "false".equals(anonymousElt.getAttribute("enabled"))) {
            return;
        }
        String grantedAuthority = null;
        String username = null;
        String key = null;
        Object source = this.pc.extractSource((Object)this.httpElt);
        if (anonymousElt != null) {
            grantedAuthority = anonymousElt.getAttribute("granted-authority");
            username = anonymousElt.getAttribute("username");
            key = anonymousElt.getAttribute("key");
            source = this.pc.extractSource((Object)anonymousElt);
        }
        if (!StringUtils.hasText(grantedAuthority)) {
            grantedAuthority = "ROLE_ANONYMOUS";
        }
        if (!StringUtils.hasText(username)) {
            username = "anonymousUser";
        }
        if (!StringUtils.hasText(key)) {
            key = Long.toString(this.random.nextLong());
        }
        this.anonymousFilter = new RootBeanDefinition(AnonymousAuthenticationFilter.class);
        PropertyValue keyPV = new PropertyValue("key", (Object)key);
        this.anonymousFilter.setSource(source);
        this.anonymousFilter.getPropertyValues().addPropertyValue("userAttribute", (Object)(username + "," + grantedAuthority));
        this.anonymousFilter.getPropertyValues().addPropertyValue(keyPV);
        RootBeanDefinition anonymousProviderBean = new RootBeanDefinition(AnonymousAuthenticationProvider.class);
        anonymousProviderBean.setSource(this.anonymousFilter.getSource());
        anonymousProviderBean.getPropertyValues().addPropertyValue(keyPV);
        String id = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)anonymousProviderBean);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)anonymousProviderBean, id));
        this.anonymousProviderRef = new RuntimeBeanReference(id);
    }

    void createExceptionTranslationFilter() {
        BeanDefinitionBuilder etfBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExceptionTranslationFilter.class);
        etfBuilder.addPropertyValue("accessDeniedHandler", (Object)this.createAccessDeniedHandler(this.httpElt, this.pc));
        assert (this.requestCache != null);
        etfBuilder.addPropertyValue("requestCache", (Object)this.requestCache);
        etfBuilder.addPropertyValue("authenticationEntryPoint", (Object)this.selectEntryPoint());
        this.etf = etfBuilder.getBeanDefinition();
    }

    void createRequestCache() {
        Element requestCacheElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"request-cache");
        if (requestCacheElt != null) {
            this.requestCache = new RuntimeBeanReference(requestCacheElt.getAttribute(ATT_REF));
            return;
        }
        BeanDefinitionBuilder requestCacheBldr = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionRequestCache.class);
        BeanDefinitionBuilder portResolver = BeanDefinitionBuilder.rootBeanDefinition(PortResolverImpl.class);
        portResolver.addPropertyReference("portMapper", this.portMapperName);
        requestCacheBldr.addPropertyValue("createSessionAllowed", (Object)this.allowSessionCreation);
        requestCacheBldr.addPropertyValue("portResolver", (Object)portResolver.getBeanDefinition());
        AbstractBeanDefinition bean = requestCacheBldr.getBeanDefinition();
        String id = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)bean);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bean, id));
        this.requestCache = new RuntimeBeanReference(id);
    }

    private BeanMetadataElement createAccessDeniedHandler(Element element, ParserContext pc) {
        String accessDeniedPage = element.getAttribute(ATT_ACCESS_DENIED_PAGE);
        WebConfigUtils.validateHttpRedirect(accessDeniedPage, pc, pc.extractSource((Object)element));
        Element accessDeniedElt = DomUtils.getChildElementByTagName((Element)element, (String)"access-denied-handler");
        BeanDefinitionBuilder accessDeniedHandler = BeanDefinitionBuilder.rootBeanDefinition(AccessDeniedHandlerImpl.class);
        if (StringUtils.hasText((String)accessDeniedPage)) {
            if (accessDeniedElt != null) {
                pc.getReaderContext().error("The attribute access-denied-page cannot be used with <access-denied-handler>", pc.extractSource((Object)accessDeniedElt));
            }
            accessDeniedHandler.addPropertyValue("errorPage", (Object)accessDeniedPage);
        }
        if (accessDeniedElt != null) {
            String errorPage = accessDeniedElt.getAttribute(ATT_ACCESS_DENIED_ERROR_PAGE);
            String ref = accessDeniedElt.getAttribute(ATT_REF);
            if (StringUtils.hasText((String)errorPage)) {
                if (StringUtils.hasText((String)ref)) {
                    pc.getReaderContext().error("The attribute error-page cannot be used together with the 'ref' attribute within <access-denied-handler>", pc.extractSource((Object)accessDeniedElt));
                }
                accessDeniedHandler.addPropertyValue("errorPage", (Object)errorPage);
            } else if (StringUtils.hasText((String)ref)) {
                return new RuntimeBeanReference(ref);
            }
        }
        return accessDeniedHandler.getBeanDefinition();
    }

    private BeanMetadataElement selectEntryPoint() {
        String customEntryPoint = this.httpElt.getAttribute(ATT_ENTRY_POINT_REF);
        if (StringUtils.hasText((String)customEntryPoint)) {
            return new RuntimeBeanReference(customEntryPoint);
        }
        Element basicAuthElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"http-basic");
        Element formLoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"form-login");
        Element openIDLoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"openid-login");
        if (basicAuthElt != null && formLoginElt == null && openIDLoginElt == null) {
            return this.basicEntryPoint;
        }
        String formLoginPage = this.getLoginFormUrl(this.formEntryPoint);
        String openIDLoginPage = this.getLoginFormUrl(this.openIDEntryPoint);
        if (formLoginPage != null && openIDLoginPage != null) {
            this.pc.getReaderContext().error("Only one login-page can be defined, either for OpenID or form-login, but not both.", this.pc.extractSource((Object)openIDLoginElt));
        }
        if (this.formFilter != null && openIDLoginPage == null) {
            return this.formEntryPoint;
        }
        if (this.openIDFilter != null) {
            return this.openIDEntryPoint;
        }
        if (DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"x509") != null) {
            return this.x509EntryPoint;
        }
        this.pc.getReaderContext().error("No AuthenticationEntryPoint could be established. Please make sure you have a login mechanism configured through the namespace (such as form-login) or specify a custom AuthenticationEntryPoint with the 'entry-point-ref' attribute ", this.pc.extractSource((Object)this.httpElt));
        return null;
    }

    private String getLoginFormUrl(BeanDefinition entryPoint) {
        if (entryPoint == null) {
            return null;
        }
        MutablePropertyValues pvs = entryPoint.getPropertyValues();
        PropertyValue pv = pvs.getPropertyValue("loginFormUrl");
        if (pv == null) {
            return null;
        }
        if ("/spring_security_login".equals(pv.getValue())) {
            return null;
        }
        return (String)pv.getValue();
    }

    void createUserServiceInjector() {
        BeanDefinitionBuilder userServiceInjector = BeanDefinitionBuilder.rootBeanDefinition(UserDetailsServiceInjectionBeanPostProcessor.class);
        userServiceInjector.addConstructorArgValue((Object)this.x509ProviderId);
        userServiceInjector.addConstructorArgValue((Object)this.rememberMeServicesId);
        userServiceInjector.addConstructorArgValue((Object)this.openIDProviderId);
        userServiceInjector.setRole(2);
        this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)userServiceInjector.getBeanDefinition());
    }

    List<OrderDecorator> getFilters() {
        ArrayList<OrderDecorator> filters = new ArrayList<OrderDecorator>();
        if (this.anonymousFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.anonymousFilter, SecurityFilters.ANONYMOUS_FILTER));
        }
        if (this.rememberMeFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.rememberMeFilter, SecurityFilters.REMEMBER_ME_FILTER));
        }
        if (this.logoutFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.logoutFilter, SecurityFilters.LOGOUT_FILTER));
        }
        if (this.x509Filter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.x509Filter, SecurityFilters.X509_FILTER));
        }
        if (this.formFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.formFilter, SecurityFilters.FORM_LOGIN_FILTER));
        }
        if (this.openIDFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.openIDFilter, SecurityFilters.OPENID_FILTER));
        }
        if (this.loginPageGenerationFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.loginPageGenerationFilter, SecurityFilters.LOGIN_PAGE_FILTER));
        }
        if (this.basicFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.basicFilter, SecurityFilters.BASIC_AUTH_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.etf, SecurityFilters.EXCEPTION_TRANSLATION_FILTER));
        return filters;
    }

    List<BeanReference> getProviders() {
        ArrayList<BeanReference> providers = new ArrayList<BeanReference>();
        if (this.anonymousProviderRef != null) {
            providers.add(this.anonymousProviderRef);
        }
        if (this.rememberMeProviderRef != null) {
            providers.add(this.rememberMeProviderRef);
        }
        if (this.openIDProviderRef != null) {
            providers.add(this.openIDProviderRef);
        }
        if (this.x509ProviderRef != null) {
            providers.add(this.x509ProviderRef);
        }
        return providers;
    }

    public BeanReference getRequestCache() {
        return this.requestCache;
    }
}

