/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import javax.mail.Message;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.springframework.integration.MessagingException;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;

public class ImapIdleChannelAdapter
extends MessageProducerSupport {
    private final IdleTask idleTask = new IdleTask();
    private volatile boolean shouldReconnectAutomatically = true;
    private final ImapMailReceiver mailReceiver;
    private volatile int reconnectDelay = 10000;
    private volatile ScheduledFuture<?> receivingTask;
    private volatile ScheduledFuture<?> pingTask;
    private volatile long connectionPingInterval = 10000L;
    private final ExceptionAwarePeriodicTrigger receivingTaskTrigger = new ExceptionAwarePeriodicTrigger();

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"'mailReceiver' must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    protected void doStart() {
        TaskScheduler scheduler = this.getTaskScheduler();
        Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
        this.receivingTask = scheduler.schedule((Runnable)new ReceivingTask(), (Trigger)this.receivingTaskTrigger);
        this.pingTask = scheduler.scheduleAtFixedRate((Runnable)new PingTask(), this.connectionPingInterval);
    }

    protected void doStop() {
        this.receivingTask.cancel(true);
        this.pingTask.cancel(true);
        try {
            this.mailReceiver.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure during the destruction of Mail receiver: " + this.mailReceiver, e);
        }
    }

    private class ExceptionAwarePeriodicTrigger
    implements Trigger {
        private volatile boolean delayNextExecution;

        private ExceptionAwarePeriodicTrigger() {
        }

        public Date nextExecutionTime(TriggerContext triggerContext) {
            if (this.delayNextExecution) {
                this.delayNextExecution = false;
                return new Date(System.currentTimeMillis() + (long)ImapIdleChannelAdapter.this.reconnectDelay);
            }
            return new Date(System.currentTimeMillis());
        }

        public void delayNextExecution() {
            this.delayNextExecution = true;
        }
    }

    private class PingTask
    implements Runnable {
        private PingTask() {
        }

        public void run() {
            try {
                Store store = ImapIdleChannelAdapter.this.mailReceiver.getStore();
                if (store != null) {
                    store.isConnected();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class IdleTask
    implements Runnable {
        private IdleTask() {
        }

        public void run() {
            TaskScheduler scheduler = ImapIdleChannelAdapter.this.getTaskScheduler();
            Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
            try {
                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                    ImapIdleChannelAdapter.this.logger.debug((Object)"waiting for mail");
                }
                ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                if (ImapIdleChannelAdapter.this.mailReceiver.getFolder().isOpen()) {
                    Message[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                    if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                        ImapIdleChannelAdapter.this.logger.debug((Object)("received " + mailMessages.length + " mail messages"));
                    }
                    for (Message mailMessage : mailMessages) {
                        MimeMessage copied = new MimeMessage((MimeMessage)mailMessage);
                        ImapIdleChannelAdapter.this.sendMessage(MessageBuilder.withPayload((Object)copied).build());
                    }
                }
            }
            catch (javax.mail.MessagingException e) {
                if (ImapIdleChannelAdapter.this.logger.isWarnEnabled()) {
                    ImapIdleChannelAdapter.this.logger.warn((Object)"error occurred in idle task", (Throwable)e);
                }
                if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically) {
                    throw new IllegalStateException("Failure in 'idle' task. Will resubmit.", e);
                }
                throw new MessagingException("Failure in 'idle' task. Will NOT resubmit.", (Throwable)e);
            }
        }
    }

    private class ReceivingTask
    implements Runnable {
        private ReceivingTask() {
        }

        public void run() {
            try {
                ImapIdleChannelAdapter.this.idleTask.run();
                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                    ImapIdleChannelAdapter.this.logger.debug((Object)"Task completed successfully. Re-scheduling it again right away.");
                }
            }
            catch (Exception e) {
                ImapIdleChannelAdapter.this.logger.warn((Object)("Failed to execute IDLE task. Will attempt to resubmit in " + ImapIdleChannelAdapter.this.reconnectDelay + " milliseconds."), (Throwable)e);
                ImapIdleChannelAdapter.this.receivingTaskTrigger.delayNextExecution();
            }
        }
    }
}

