/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.WebClient;

public class HypermediaWebClientConfigurer {
    final Consumer<ClientCodecConfigurer> configurer;

    HypermediaWebClientConfigurer(ObjectMapper mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull(hypermediaTypes, (String)"HypermediaMappingInformations must not be null!");
        this.configurer = clientCodecConfigurer -> hypermediaTypes.forEach(hypermediaType -> {
            ObjectMapper objectMapper = hypermediaType.configureObjectMapper(mapper.copy());
            MimeType[] mimeTypes = hypermediaType.getMediaTypes().toArray(new MimeType[0]);
            clientCodecConfigurer.customCodecs().registerWithDefaultConfig((Object)new Jackson2JsonEncoder(objectMapper, mimeTypes));
            clientCodecConfigurer.customCodecs().registerWithDefaultConfig((Object)new Jackson2JsonDecoder(objectMapper, mimeTypes));
        });
    }

    public WebClient.Builder registerHypermediaTypes(WebClient.Builder builder) {
        return builder.codecs(this.configurer);
    }
}

