/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveListOperations<K, V> {
    public Flux<V> range(K var1, long var2, long var4);

    public Mono<Boolean> trim(K var1, long var2, long var4);

    public Mono<Long> size(K var1);

    public Mono<Long> leftPush(K var1, V var2);

    public Mono<Long> leftPushAll(K var1, V ... var2);

    public Mono<Long> leftPushAll(K var1, Collection<V> var2);

    public Mono<Long> leftPushIfPresent(K var1, V var2);

    public Mono<Long> leftPush(K var1, V var2, V var3);

    public Mono<Long> rightPush(K var1, V var2);

    public Mono<Long> rightPushAll(K var1, V ... var2);

    public Mono<Long> rightPushAll(K var1, Collection<V> var2);

    public Mono<Long> rightPushIfPresent(K var1, V var2);

    public Mono<Long> rightPush(K var1, V var2, V var3);

    default public Mono<V> move(ListOperations.MoveFrom<K> from, ListOperations.MoveTo<K> to) {
        Assert.notNull(from, (String)"Move from must not be null");
        Assert.notNull(to, (String)"Move to must not be null");
        return this.move(from.key, ReactiveListCommands.Direction.valueOf(from.direction.name()), to.key, ReactiveListCommands.Direction.valueOf(to.direction.name()));
    }

    public Mono<V> move(K var1, ReactiveListCommands.Direction var2, K var3, ReactiveListCommands.Direction var4);

    default public Mono<V> move(ListOperations.MoveFrom<K> from, ListOperations.MoveTo<K> to, Duration timeout) {
        Assert.notNull(from, (String)"Move from must not be null");
        Assert.notNull(to, (String)"Move to must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.move(from.key, ReactiveListCommands.Direction.valueOf(from.direction.name()), to.key, ReactiveListCommands.Direction.valueOf(to.direction.name()), timeout);
    }

    public Mono<V> move(K var1, ReactiveListCommands.Direction var2, K var3, ReactiveListCommands.Direction var4, Duration var5);

    public Mono<Boolean> set(K var1, long var2, V var4);

    public Mono<Long> remove(K var1, long var2, Object var4);

    @Nullable
    default public Mono<V> getFirst(K key) {
        return this.index(key, 0L);
    }

    @Nullable
    default public Mono<V> getLast(K key) {
        return this.index(key, -1L);
    }

    public Mono<V> index(K var1, long var2);

    public Mono<Long> indexOf(K var1, V var2);

    public Mono<Long> lastIndexOf(K var1, V var2);

    public Mono<V> leftPop(K var1);

    public Flux<V> leftPop(K var1, long var2);

    public Mono<V> leftPop(K var1, Duration var2);

    public Mono<V> rightPop(K var1);

    public Flux<V> rightPop(K var1, long var2);

    public Mono<V> rightPop(K var1, Duration var2);

    public Mono<V> rightPopAndLeftPush(K var1, K var2);

    public Mono<V> rightPopAndLeftPush(K var1, K var2, Duration var3);

    public Mono<Boolean> delete(K var1);
}

