/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;

abstract class FetchableFluentQuerySupport<P, T>
implements FluentQuery.FetchableFluentQuery<T> {
    private final P predicate;
    private final Sort sort;
    private final int limit;
    private final Class<T> resultType;
    private final List<String> fieldsToInclude;

    FetchableFluentQuerySupport(P predicate, Sort sort, int limit, Class<T> resultType, List<String> fieldsToInclude) {
        this.predicate = predicate;
        this.sort = sort;
        this.limit = limit;
        this.resultType = resultType;
        this.fieldsToInclude = fieldsToInclude;
    }

    public FluentQuery.FetchableFluentQuery<T> sortBy(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return this.create(this.predicate, sort, this.limit, this.resultType, this.fieldsToInclude);
    }

    public FluentQuery.FetchableFluentQuery<T> limit(int limit) {
        Assert.isTrue((limit > 0 ? 1 : 0) != 0, (String)"Limit must be greater zero");
        return this.create(this.predicate, this.sort, limit, this.resultType, this.fieldsToInclude);
    }

    public <R> FluentQuery.FetchableFluentQuery<R> as(Class<R> projection) {
        Assert.notNull(projection, (String)"Projection target type must not be null");
        return this.create(this.predicate, this.sort, this.limit, projection, this.fieldsToInclude);
    }

    public FluentQuery.FetchableFluentQuery<T> project(Collection<String> properties) {
        Assert.notNull(properties, (String)"Projection properties must not be null");
        return this.create(this.predicate, this.sort, this.limit, this.resultType, new ArrayList<String>(properties));
    }

    protected abstract <R> FetchableFluentQuerySupport<P, R> create(P var1, Sort var2, int var3, Class<R> var4, List<String> var5);

    P getPredicate() {
        return this.predicate;
    }

    Sort getSort() {
        return this.sort;
    }

    int getLimit() {
        return this.limit;
    }

    Class<T> getResultType() {
        return this.resultType;
    }

    List<String> getFieldsToInclude() {
        return this.fieldsToInclude;
    }
}

