/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bson.Document;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.FetchableFluentQuerySupport;
import org.springframework.data.mongodb.repository.support.QuerydslPredicateExecutorSupport;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuery;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;

public class QuerydslMongoPredicateExecutor<T>
extends QuerydslPredicateExecutorSupport<T>
implements QuerydslPredicateExecutor<T> {
    private final MongoOperations mongoOperations;

    public QuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, MongoOperations mongoOperations) {
        this(entityInformation, mongoOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public QuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, MongoOperations mongoOperations, EntityPathResolver resolver) {
        super(mongoOperations.getConverter(), QuerydslMongoPredicateExecutor.pathBuilderFor(resolver.createPath(entityInformation.getJavaType())), entityInformation);
        this.mongoOperations = mongoOperations;
    }

    public Optional<T> findOne(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        try {
            return Optional.ofNullable(this.createQueryFor(predicate).fetchOne());
        }
        catch (NonUniqueResultException ex) {
            throw new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
    }

    public List<T> findAll(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQueryFor(predicate).fetch();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(orders, (String)"Order specifiers must not be null");
        return ((SpringDataMongodbQuery)this.createQueryFor(predicate).orderBy(orders)).fetch();
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return this.applySorting(this.createQueryFor(predicate), sort).fetch();
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"Order specifiers must not be null");
        return ((SpringDataMongodbQuery)this.createQuery().orderBy(orders)).fetch();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        SpringDataMongodbQuery<T> query = this.createQueryFor(predicate);
        return PageableExecutionUtils.getPage(this.applyPagination(query, pageable).fetch(), (Pageable)pageable, query::fetchCount);
    }

    public long count(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQueryFor(predicate).fetchCount();
    }

    public boolean exists(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQueryFor(predicate).fetchCount() > 0L;
    }

    public <S extends T, R> R findBy(Predicate predicate, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new FluentQuerydsl(predicate, this.typeInformation().getJavaType()));
    }

    private SpringDataMongodbQuery<T> createQueryFor(Predicate predicate) {
        return (SpringDataMongodbQuery)this.createQuery().where(predicate);
    }

    private SpringDataMongodbQuery<T> createQuery() {
        return new SpringDataMongodbQuery(this.mongoOperations, this.typeInformation().getJavaType());
    }

    private SpringDataMongodbQuery<T> applyPagination(SpringDataMongodbQuery<T> query, Pageable pageable) {
        if (pageable.isPaged()) {
            query = (SpringDataMongodbQuery)((SpringDataMongodbQuery)query.offset(pageable.getOffset())).limit(pageable.getPageSize());
        }
        return this.applySorting(query, pageable.getSort());
    }

    private SpringDataMongodbQuery<T> applySorting(SpringDataMongodbQuery<T> query, Sort sort) {
        this.toOrderSpecifiers(sort).forEach(arg_0 -> query.orderBy(arg_0));
        return query;
    }

    class FluentQuerydsl<T>
    extends FetchableFluentQuerySupport<Predicate, T> {
        FluentQuerydsl(Predicate predicate, Class<T> resultType) {
            this(predicate, Sort.unsorted(), 0, resultType, Collections.emptyList());
        }

        FluentQuerydsl(Predicate predicate, Sort sort, int limit, Class<T> resultType, List<String> fieldsToInclude) {
            super(predicate, sort, limit, resultType, fieldsToInclude);
        }

        protected <R> FluentQuerydsl<R> create(Predicate predicate, Sort sort, int limit, Class<R> resultType, List<String> fieldsToInclude) {
            return new FluentQuerydsl<R>(predicate, sort, limit, resultType, fieldsToInclude);
        }

        public T oneValue() {
            return this.createQuery().fetchOne();
        }

        public T firstValue() {
            return this.createQuery().fetchFirst();
        }

        public List<T> all() {
            return this.createQuery().fetch();
        }

        public Window<T> scroll(ScrollPosition scrollPosition) {
            return this.createQuery().scroll(scrollPosition);
        }

        public Page<T> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            return this.createQuery().fetchPage(pageable);
        }

        public Slice<T> slice(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            return this.createQuery().fetchSlice(pageable);
        }

        public Stream<T> stream() {
            return this.createQuery().stream();
        }

        public long count() {
            return this.createQuery().fetchCount();
        }

        public boolean exists() {
            return this.count() > 0L;
        }

        private SpringDataMongodbQuery<T> createQuery() {
            return (SpringDataMongodbQuery)new SpringDataMongodbQuery(QuerydslMongoPredicateExecutor.this.mongoOperations, QuerydslMongoPredicateExecutor.this.typeInformation().getJavaType(), this.getResultType(), QuerydslMongoPredicateExecutor.this.mongoOperations.getCollectionName(QuerydslMongoPredicateExecutor.this.typeInformation().getJavaType()), this::customize).where((Predicate)this.getPredicate());
        }

        private void customize(BasicQuery query) {
            List<String> fieldsToInclude = this.getFieldsToInclude();
            if (!fieldsToInclude.isEmpty()) {
                Document fields = new Document();
                fieldsToInclude.forEach(field -> fields.put(field, (Object)1));
                query.setFieldsObject(fields);
            }
            if (this.getSort().isSorted()) {
                query.with(this.getSort());
            }
            query.limit(this.getLimit());
        }
    }
}

