/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.util.Assert;

public class SortOperation
implements AggregationOperation {
    private final Sort sort;

    public SortOperation(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        this.sort = sort;
    }

    public SortOperation and(Sort.Direction direction, String ... fields) {
        return this.and(new Sort(direction, fields));
    }

    public SortOperation and(Sort sort) {
        return new SortOperation(this.sort.and(sort));
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject object = new BasicDBObject();
        for (Sort.Order order : this.sort) {
            ExposedFields.FieldReference reference = context.getReference(order.getProperty());
            object.put(reference.getRaw(), (Object)(order.isAscending() ? 1 : -1));
        }
        return new BasicDBObject("$sort", (Object)object);
    }
}

