/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoOptions;
import javax.net.ssl.SSLSocketFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class MongoOptionsFactoryBean
implements FactoryBean<MongoOptions>,
InitializingBean {
    private static final MongoOptions DEFAULT_MONGO_OPTIONS = new MongoOptions();
    private int connectionsPerHost;
    private int threadsAllowedToBlockForConnectionMultiplier;
    private int maxWaitTime;
    private int connectTimeout;
    private int socketTimeout;
    private boolean socketKeepAlive;
    private boolean autoConnectRetry;
    private long maxAutoConnectRetryTime;
    private int writeNumber;
    private int writeTimeout;
    private boolean writeFsync;
    private boolean slaveOk;
    private boolean ssl;
    private SSLSocketFactory sslSocketFactory;
    private MongoOptions options;

    public MongoOptionsFactoryBean() {
        this.connectionsPerHost = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.connectionsPerHost;
        this.threadsAllowedToBlockForConnectionMultiplier = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.threadsAllowedToBlockForConnectionMultiplier;
        this.maxWaitTime = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.maxWaitTime;
        this.connectTimeout = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.connectTimeout;
        this.socketTimeout = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.socketTimeout;
        this.socketKeepAlive = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.socketKeepAlive;
        this.autoConnectRetry = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.autoConnectRetry;
        this.maxAutoConnectRetryTime = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.maxAutoConnectRetryTime;
        this.writeNumber = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.w;
        this.writeTimeout = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.wtimeout;
        this.writeFsync = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.fsync;
        this.slaveOk = MongoOptionsFactoryBean.DEFAULT_MONGO_OPTIONS.slaveOk;
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public void setWriteNumber(int writeNumber) {
        this.writeNumber = writeNumber;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setWriteFsync(boolean writeFsync) {
        this.writeFsync = writeFsync;
    }

    public void setAutoConnectRetry(boolean autoConnectRetry) {
        this.autoConnectRetry = autoConnectRetry;
    }

    public void setMaxAutoConnectRetryTime(long maxAutoConnectRetryTime) {
        this.maxAutoConnectRetryTime = maxAutoConnectRetryTime;
    }

    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.setSsl(sslSocketFactory != null);
        this.sslSocketFactory = sslSocketFactory;
    }

    public void afterPropertiesSet() {
        MongoOptions options = new MongoOptions();
        options.connectionsPerHost = this.connectionsPerHost;
        options.threadsAllowedToBlockForConnectionMultiplier = this.threadsAllowedToBlockForConnectionMultiplier;
        options.maxWaitTime = this.maxWaitTime;
        options.connectTimeout = this.connectTimeout;
        options.socketTimeout = this.socketTimeout;
        options.socketKeepAlive = this.socketKeepAlive;
        options.autoConnectRetry = this.autoConnectRetry;
        options.maxAutoConnectRetryTime = this.maxAutoConnectRetryTime;
        options.slaveOk = this.slaveOk;
        options.w = this.writeNumber;
        options.wtimeout = this.writeTimeout;
        options.fsync = this.writeFsync;
        if (this.ssl) {
            options.setSocketFactory(this.sslSocketFactory != null ? this.sslSocketFactory : SSLSocketFactory.getDefault());
        }
        this.options = options;
    }

    public MongoOptions getObject() {
        return this.options;
    }

    public Class<?> getObjectType() {
        return MongoOptions.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

