/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.MethodReference;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MethodReferenceNode
extends ExpressionNode {
    private static final Map<String, AggregationMethodReference> FUNCTIONS;

    MethodReferenceNode(MethodReference reference, ExpressionState state) {
        super((SpelNode)reference, state);
    }

    @Deprecated
    public String getMethodName() {
        AggregationMethodReference methodReference = this.getMethodReference();
        return methodReference != null ? methodReference.getMongoOperator() : null;
    }

    public AggregationMethodReference getMethodReference() {
        String name = this.getName();
        String methodName = name.substring(0, name.indexOf(40));
        return FUNCTIONS.get(methodName);
    }

    static {
        HashMap<String, AggregationMethodReference> map = new HashMap<String, AggregationMethodReference>();
        map.put("and", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$and"));
        map.put("or", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$or"));
        map.put("not", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$not"));
        map.put("setEquals", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$setEquals"));
        map.put("setIntersection", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$setIntersection"));
        map.put("setUnion", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$setUnion"));
        map.put("setDifference", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$setDifference"));
        map.put("setIsSubset", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$setIsSubset"));
        map.put("anyElementTrue", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$anyElementTrue"));
        map.put("allElementsTrue", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$allElementsTrue"));
        map.put("cmp", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$cmp"));
        map.put("eq", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$eq"));
        map.put("gt", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$gt"));
        map.put("gte", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$gte"));
        map.put("lt", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$lt"));
        map.put("lte", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$lte"));
        map.put("ne", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$ne"));
        map.put("abs", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$abs"));
        map.put("add", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$add"));
        map.put("ceil", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$ceil"));
        map.put("divide", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$divide"));
        map.put("exp", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$exp"));
        map.put("floor", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$floor"));
        map.put("ln", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$ln"));
        map.put("log", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$log"));
        map.put("log10", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$log10"));
        map.put("mod", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$mod"));
        map.put("multiply", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$multiply"));
        map.put("pow", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$pow"));
        map.put("sqrt", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$sqrt"));
        map.put("subtract", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$subtract"));
        map.put("trunc", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$trunc"));
        map.put("concat", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$concat"));
        map.put("strcasecmp", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$strcasecmp"));
        map.put("substr", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$substr"));
        map.put("toLower", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$toLower"));
        map.put("toUpper", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$toUpper"));
        map.put("strcasecmp", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$strcasecmp"));
        map.put("indexOfBytes", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$indexOfBytes"));
        map.put("indexOfCP", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$indexOfCP"));
        map.put("split", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$split"));
        map.put("strLenBytes", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$strLenBytes"));
        map.put("strLenCP", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$strLenCP"));
        map.put("substrCP", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$substrCP"));
        map.put("meta", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$meta"));
        map.put("arrayElemAt", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$arrayElemAt"));
        map.put("concatArrays", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$concatArrays"));
        map.put("filter", AggregationMethodReference.mapArgumentAggregationMethodReference().forOperator("$filter").mappingParametersTo("input", "as", "cond"));
        map.put("isArray", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$isArray"));
        map.put("size", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$size"));
        map.put("slice", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$slice"));
        map.put("reverseArray", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$reverseArray"));
        map.put("reduce", AggregationMethodReference.mapArgumentAggregationMethodReference().forOperator("$reduce").mappingParametersTo("input", "initialValue", "in"));
        map.put("zip", AggregationMethodReference.mapArgumentAggregationMethodReference().forOperator("$zip").mappingParametersTo("inputs", "useLongestLength", "defaults"));
        map.put("in", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$in"));
        map.put("map", AggregationMethodReference.mapArgumentAggregationMethodReference().forOperator("$map").mappingParametersTo("input", "as", "in"));
        map.put("let", AggregationMethodReference.mapArgumentAggregationMethodReference().forOperator("$let").mappingParametersTo("vars", "in"));
        map.put("literal", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$literal"));
        map.put("dayOfYear", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$dayOfYear"));
        map.put("dayOfMonth", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$dayOfMonth"));
        map.put("dayOfWeek", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$dayOfWeek"));
        map.put("year", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$year"));
        map.put("month", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$month"));
        map.put("week", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$week"));
        map.put("hour", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$hour"));
        map.put("minute", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$minute"));
        map.put("second", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$second"));
        map.put("millisecond", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$millisecond"));
        map.put("dateToString", AggregationMethodReference.mapArgumentAggregationMethodReference().forOperator("$dateToString").mappingParametersTo("format", "date"));
        map.put("isoDayOfWeek", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$isoDayOfWeek"));
        map.put("isoWeek", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$isoWeek"));
        map.put("isoWeekYear", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$isoWeekYear"));
        map.put("cond", AggregationMethodReference.mapArgumentAggregationMethodReference().forOperator("$cond").mappingParametersTo("if", "then", "else"));
        map.put("ifNull", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$ifNull"));
        map.put("sum", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$sum"));
        map.put("avg", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$avg"));
        map.put("first", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$first"));
        map.put("last", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$last"));
        map.put("max", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$max"));
        map.put("min", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$min"));
        map.put("push", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$push"));
        map.put("addToSet", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$addToSet"));
        map.put("stdDevPop", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$stdDevPop"));
        map.put("stdDevSamp", AggregationMethodReference.arrayArgumentAggregationMethodReference().forOperator("$stdDevSamp"));
        map.put("type", AggregationMethodReference.singleArgumentAggregationMethodReference().forOperator("$type"));
        FUNCTIONS = Collections.unmodifiableMap(map);
    }

    public static final class AggregationMethodReference {
        private final String mongoOperator;
        private final ArgumentType argumentType;
        private final String[] argumentMap;

        private AggregationMethodReference(String mongoOperator, ArgumentType argumentType, String[] argumentMap) {
            this.mongoOperator = mongoOperator;
            this.argumentType = argumentType;
            this.argumentMap = argumentMap;
        }

        public String getMongoOperator() {
            return this.mongoOperator;
        }

        public ArgumentType getArgumentType() {
            return this.argumentType;
        }

        public String[] getArgumentMap() {
            return this.argumentMap != null ? this.argumentMap : new String[]{};
        }

        static AggregationMethodReference singleArgumentAggregationMethodReference() {
            return new AggregationMethodReference(null, ArgumentType.SINGLE, null);
        }

        static AggregationMethodReference arrayArgumentAggregationMethodReference() {
            return new AggregationMethodReference(null, ArgumentType.ARRAY, null);
        }

        static AggregationMethodReference mapArgumentAggregationMethodReference() {
            return new AggregationMethodReference(null, ArgumentType.MAP, null);
        }

        AggregationMethodReference forOperator(String aggregationExpressionOperator) {
            return new AggregationMethodReference(aggregationExpressionOperator, this.argumentType, this.argumentMap);
        }

        AggregationMethodReference mappingParametersTo(String ... aggregationExpressionProperties) {
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)((Object)this.argumentType), (Object)((Object)ArgumentType.MAP)), (String)"Parameter mapping can only be applied to AggregationMethodReference with MAPPED ArgumentType.");
            return new AggregationMethodReference(this.mongoOperator, this.argumentType, aggregationExpressionProperties);
        }

        public static enum ArgumentType {
            SINGLE,
            ARRAY,
            MAP;

        }
    }
}

