/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;

class SpecificationComposition {
    SpecificationComposition() {
    }

    static <T> Specification<T> composed(@Nullable Specification<T> lhs, @Nullable Specification<T> rhs, Combiner combiner) {
        return (root, query, builder) -> {
            Predicate thisPredicate = SpecificationComposition.toPredicate(lhs, root, query, builder);
            Predicate otherPredicate = SpecificationComposition.toPredicate(rhs, root, query, builder);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    @Nullable
    private static <T> Predicate toPredicate(@Nullable Specification<T> specification, Root<T> root, @Nullable CriteriaQuery<?> query, CriteriaBuilder builder) {
        return specification == null ? null : specification.toPredicate(root, query, builder);
    }

    static interface Combiner
    extends Serializable {
        public Predicate combine(CriteriaBuilder var1, @Nullable Predicate var2, @Nullable Predicate var3);
    }
}

