/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.pubsub;

import com.google.api.gax.batching.FlowController;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.gcp.core.Credentials;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.GcpScope;

@ConfigurationProperties(value="spring.cloud.gcp.pubsub")
public class GcpPubSubProperties
implements CredentialsSupplier {
    private final Subscriber subscriber = new Subscriber();
    private final Publisher publisher = new Publisher();
    private String projectId;
    private String emulatorHost;
    private int keepAliveIntervalMinutes = 5;
    @NestedConfigurationProperty
    private final Credentials credentials = new Credentials(new String[]{GcpScope.PUBSUB.getUrl()});

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getEmulatorHost() {
        return this.emulatorHost;
    }

    public void setEmulatorHost(String emulatorHost) {
        this.emulatorHost = emulatorHost;
    }

    public int getKeepAliveIntervalMinutes() {
        return this.keepAliveIntervalMinutes;
    }

    public void setKeepAliveIntervalMinutes(int keepAliveIntervalMinutes) {
        this.keepAliveIntervalMinutes = keepAliveIntervalMinutes;
    }

    public static class Batching {
        private final FlowControl flowControl = new FlowControl();
        private Long elementCountThreshold;
        private Long requestByteThreshold;
        private Long delayThresholdSeconds;
        private Boolean enabled;

        public Long getElementCountThreshold() {
            return this.elementCountThreshold;
        }

        public void setElementCountThreshold(Long elementCountThreshold) {
            this.elementCountThreshold = elementCountThreshold;
        }

        public Long getRequestByteThreshold() {
            return this.requestByteThreshold;
        }

        public void setRequestByteThreshold(Long requestByteThreshold) {
            this.requestByteThreshold = requestByteThreshold;
        }

        public Long getDelayThresholdSeconds() {
            return this.delayThresholdSeconds;
        }

        public void setDelayThresholdSeconds(Long delayThresholdSeconds) {
            this.delayThresholdSeconds = delayThresholdSeconds;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public FlowControl getFlowControl() {
            return this.flowControl;
        }
    }

    public static class FlowControl {
        private Long maxOutstandingElementCount;
        private Long maxOutstandingRequestBytes;
        private FlowController.LimitExceededBehavior limitExceededBehavior;

        public Long getMaxOutstandingElementCount() {
            return this.maxOutstandingElementCount;
        }

        public void setMaxOutstandingElementCount(Long maxOutstandingElementCount) {
            this.maxOutstandingElementCount = maxOutstandingElementCount;
        }

        public Long getMaxOutstandingRequestBytes() {
            return this.maxOutstandingRequestBytes;
        }

        public void setMaxOutstandingRequestBytes(Long maxOutstandingRequestBytes) {
            this.maxOutstandingRequestBytes = maxOutstandingRequestBytes;
        }

        public FlowController.LimitExceededBehavior getLimitExceededBehavior() {
            return this.limitExceededBehavior;
        }

        public void setLimitExceededBehavior(FlowController.LimitExceededBehavior limitExceededBehavior) {
            this.limitExceededBehavior = limitExceededBehavior;
        }
    }

    public static class Retry {
        private Long totalTimeoutSeconds;
        private Long initialRetryDelaySeconds;
        private Double retryDelayMultiplier;
        private Long maxRetryDelaySeconds;
        private Integer maxAttempts;
        private Boolean jittered;
        private Long initialRpcTimeoutSeconds;
        private Double rpcTimeoutMultiplier;
        private Long maxRpcTimeoutSeconds;

        public Long getTotalTimeoutSeconds() {
            return this.totalTimeoutSeconds;
        }

        public void setTotalTimeoutSeconds(Long totalTimeoutSeconds) {
            this.totalTimeoutSeconds = totalTimeoutSeconds;
        }

        public Long getInitialRetryDelaySeconds() {
            return this.initialRetryDelaySeconds;
        }

        public void setInitialRetryDelaySeconds(Long initialRetryDelaySeconds) {
            this.initialRetryDelaySeconds = initialRetryDelaySeconds;
        }

        public Double getRetryDelayMultiplier() {
            return this.retryDelayMultiplier;
        }

        public void setRetryDelayMultiplier(Double retryDelayMultiplier) {
            this.retryDelayMultiplier = retryDelayMultiplier;
        }

        public Long getMaxRetryDelaySeconds() {
            return this.maxRetryDelaySeconds;
        }

        public void setMaxRetryDelaySeconds(Long maxRetryDelaySeconds) {
            this.maxRetryDelaySeconds = maxRetryDelaySeconds;
        }

        public Integer getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public Boolean getJittered() {
            return this.jittered;
        }

        public void setJittered(Boolean jittered) {
            this.jittered = jittered;
        }

        public Long getInitialRpcTimeoutSeconds() {
            return this.initialRpcTimeoutSeconds;
        }

        public void setInitialRpcTimeoutSeconds(Long initialRpcTimeoutSeconds) {
            this.initialRpcTimeoutSeconds = initialRpcTimeoutSeconds;
        }

        public Double getRpcTimeoutMultiplier() {
            return this.rpcTimeoutMultiplier;
        }

        public void setRpcTimeoutMultiplier(Double rpcTimeoutMultiplier) {
            this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
        }

        public Long getMaxRpcTimeoutSeconds() {
            return this.maxRpcTimeoutSeconds;
        }

        public void setMaxRpcTimeoutSeconds(Long maxRpcTimeoutSeconds) {
            this.maxRpcTimeoutSeconds = maxRpcTimeoutSeconds;
        }
    }

    public static class Subscriber {
        private int executorThreads = 4;
        private int maxAcknowledgementThreads = 4;
        private String pullEndpoint;
        private Long maxAckExtensionPeriod = 0L;
        private Integer parallelPullCount;
        private final Retry retry = new Retry();
        private final FlowControl flowControl = new FlowControl();

        public Retry getRetry() {
            return this.retry;
        }

        public FlowControl getFlowControl() {
            return this.flowControl;
        }

        public String getPullEndpoint() {
            return this.pullEndpoint;
        }

        public void setPullEndpoint(String pullEndpoint) {
            this.pullEndpoint = pullEndpoint;
        }

        public Long getMaxAckExtensionPeriod() {
            return this.maxAckExtensionPeriod;
        }

        public void setMaxAckExtensionPeriod(Long maxAckExtensionPeriod) {
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
        }

        public Integer getParallelPullCount() {
            return this.parallelPullCount;
        }

        public void setParallelPullCount(Integer parallelPullCount) {
            this.parallelPullCount = parallelPullCount;
        }

        public int getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }

        public int getMaxAcknowledgementThreads() {
            return this.maxAcknowledgementThreads;
        }

        public void setMaxAcknowledgementThreads(int maxAcknowledgementThreads) {
            this.maxAcknowledgementThreads = maxAcknowledgementThreads;
        }
    }

    public static class Publisher {
        private int executorThreads = 4;
        private final Retry retry = new Retry();
        private final Batching batching = new Batching();

        public Batching getBatching() {
            return this.batching;
        }

        public Retry getRetry() {
            return this.retry;
        }

        public int getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }
    }
}

