/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class Configurations {
    private static final Comparator<Object> COMPARATOR = OrderComparator.INSTANCE.thenComparing(other -> other.getClass().getName());
    private final UnaryOperator<Collection<Class<?>>> sorter;
    private final Set<Class<?>> classes;
    private final Function<Class<?>, String> beanNameGenerator;

    protected Configurations(Collection<Class<?>> classes) {
        Assert.notNull(classes, (String)"Classes must not be null");
        Collection<Class<?>> sorted = this.sort(classes);
        this.sorter = null;
        this.classes = Collections.unmodifiableSet(new LinkedHashSet(sorted));
        this.beanNameGenerator = null;
    }

    protected Configurations(UnaryOperator<Collection<Class<?>>> sorter, Collection<Class<?>> classes, Function<Class<?>, String> beanNameGenerator) {
        Assert.notNull(classes, (String)"Classes must not be null");
        sorter = sorter != null ? sorter : UnaryOperator.identity();
        Collection sorted = (Collection)sorter.apply(classes);
        this.sorter = sorter != null ? sorter : UnaryOperator.identity();
        this.classes = Collections.unmodifiableSet(new LinkedHashSet(sorted));
        this.beanNameGenerator = beanNameGenerator;
    }

    protected final Set<Class<?>> getClasses() {
        return this.classes;
    }

    @Deprecated(since="3.4.0", forRemoval=true)
    protected Collection<Class<?>> sort(Collection<Class<?>> classes) {
        return classes;
    }

    protected Configurations merge(Configurations other) {
        LinkedHashSet<Class<Object>> mergedClasses = new LinkedHashSet(this.getClasses());
        mergedClasses.addAll(other.getClasses());
        if (this.sorter != null) {
            mergedClasses = new LinkedHashSet((Collection)this.sorter.apply(mergedClasses));
        }
        return this.merge(mergedClasses);
    }

    protected abstract Configurations merge(Set<Class<?>> var1);

    public String getBeanName(Class<?> beanClass) {
        return this.beanNameGenerator != null ? this.beanNameGenerator.apply(beanClass) : null;
    }

    public static Class<?>[] getClasses(Configurations ... configurations) {
        return Configurations.getClasses(Arrays.asList(configurations));
    }

    public static Class<?>[] getClasses(Collection<Configurations> configurations) {
        List<Configurations> collated = Configurations.collate(configurations);
        LinkedHashSet classes = collated.stream().flatMap(Configurations::streamClasses).collect(Collectors.toCollection(LinkedHashSet::new));
        return ClassUtils.toClassArray((Collection)classes);
    }

    public static List<Configurations> collate(Collection<Configurations> configurations) {
        LinkedList<Configurations> collated = new LinkedList<Configurations>();
        for (Configurations configuration : Configurations.sortConfigurations(configurations)) {
            if (collated.isEmpty() || collated.getLast().getClass() != configuration.getClass()) {
                collated.add(configuration);
                continue;
            }
            collated.set(collated.size() - 1, collated.getLast().merge(configuration));
        }
        return collated;
    }

    private static List<Configurations> sortConfigurations(Collection<Configurations> configurations) {
        ArrayList<Configurations> sorted = new ArrayList<Configurations>(configurations);
        sorted.sort(COMPARATOR);
        return sorted;
    }

    private static Stream<Class<?>> streamClasses(Configurations configurations) {
        return configurations.getClasses().stream();
    }
}

