/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import java.security.KeyStore;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreDetails;
import org.springframework.boot.ssl.pem.PemSslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.SslStoreProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.function.ThrowingSupplier;

public final class WebServerSslBundle
implements SslBundle {
    private final SslStoreBundle stores;
    private final SslBundleKey key;
    private final SslOptions options;
    private final String protocol;
    private final SslManagerBundle managers;

    private WebServerSslBundle(SslStoreBundle stores, String keyPassword, Ssl ssl) {
        this.stores = stores;
        this.key = SslBundleKey.of(keyPassword, ssl.getKeyAlias());
        this.protocol = ssl.getProtocol();
        this.options = SslOptions.of(ssl.getCiphers(), ssl.getEnabledProtocols());
        this.managers = SslManagerBundle.from(this.stores, this.key);
    }

    private static SslStoreBundle createPemStoreBundle(Ssl ssl) {
        PemSslStoreDetails keyStoreDetails = new PemSslStoreDetails(ssl.getKeyStoreType(), ssl.getCertificate(), ssl.getCertificatePrivateKey()).withAlias(ssl.getKeyAlias());
        PemSslStoreDetails trustStoreDetails = new PemSslStoreDetails(ssl.getTrustStoreType(), ssl.getTrustCertificate(), ssl.getTrustCertificatePrivateKey());
        return new PemSslStoreBundle(keyStoreDetails, trustStoreDetails);
    }

    private static SslStoreBundle createJksStoreBundle(Ssl ssl) {
        JksSslStoreDetails keyStoreDetails = new JksSslStoreDetails(ssl.getKeyStoreType(), ssl.getKeyStoreProvider(), ssl.getKeyStore(), ssl.getKeyStorePassword());
        JksSslStoreDetails trustStoreDetails = new JksSslStoreDetails(ssl.getTrustStoreType(), ssl.getTrustStoreProvider(), ssl.getTrustStore(), ssl.getTrustStorePassword());
        return new JksSslStoreBundle(keyStoreDetails, trustStoreDetails);
    }

    @Override
    public SslStoreBundle getStores() {
        return this.stores;
    }

    @Override
    public SslBundleKey getKey() {
        return this.key;
    }

    @Override
    public SslOptions getOptions() {
        return this.options;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public SslManagerBundle getManagers() {
        return this.managers;
    }

    public static SslBundle get(Ssl ssl) throws NoSuchSslBundleException {
        return WebServerSslBundle.get(ssl, null, null);
    }

    public static SslBundle get(Ssl ssl, SslBundles sslBundles) throws NoSuchSslBundleException {
        return WebServerSslBundle.get(ssl, sslBundles, null);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public static SslBundle get(Ssl ssl, SslBundles sslBundles, SslStoreProvider sslStoreProvider) {
        Assert.state((boolean)Ssl.isEnabled(ssl), (String)"SSL is not enabled");
        String keyPassword = sslStoreProvider != null ? sslStoreProvider.getKeyPassword() : null;
        String string = keyPassword = keyPassword != null ? keyPassword : ssl.getKeyPassword();
        if (sslStoreProvider != null) {
            SslStoreProviderBundleAdapter stores = new SslStoreProviderBundleAdapter(sslStoreProvider);
            return new WebServerSslBundle(stores, keyPassword, ssl);
        }
        String bundleName = ssl.getBundle();
        if (StringUtils.hasText((String)bundleName)) {
            Assert.state((sslBundles != null ? 1 : 0) != 0, () -> "SSL bundle '%s' was requested but no SslBundles instance was provided".formatted(bundleName));
            return sslBundles.getBundle(bundleName);
        }
        SslStoreBundle stores = WebServerSslBundle.createStoreBundle(ssl);
        return new WebServerSslBundle(stores, keyPassword, ssl);
    }

    private static SslStoreBundle createStoreBundle(Ssl ssl) {
        if (WebServerSslBundle.hasCertificateProperties(ssl)) {
            return WebServerSslBundle.createPemStoreBundle(ssl);
        }
        if (WebServerSslBundle.hasJavaKeyStoreProperties(ssl)) {
            return WebServerSslBundle.createJksStoreBundle(ssl);
        }
        throw new IllegalStateException("SSL is enabled but no trust material is configured");
    }

    static SslBundle createCertificateFileSslStoreProviderDelegate(Ssl ssl) {
        if (!WebServerSslBundle.hasCertificateProperties(ssl)) {
            return null;
        }
        SslStoreBundle stores = WebServerSslBundle.createPemStoreBundle(ssl);
        return new WebServerSslBundle(stores, ssl.getKeyPassword(), ssl);
    }

    private static boolean hasCertificateProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && ssl.getCertificate() != null && ssl.getCertificatePrivateKey() != null;
    }

    private static boolean hasJavaKeyStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && ssl.getKeyStore() != null || ssl.getKeyStoreType() != null && ssl.getKeyStoreType().equals("PKCS11");
    }

    private static class SslStoreProviderBundleAdapter
    implements SslStoreBundle {
        private final SslStoreProvider sslStoreProvider;

        SslStoreProviderBundleAdapter(SslStoreProvider sslStoreProvider) {
            this.sslStoreProvider = sslStoreProvider;
        }

        @Override
        public KeyStore getKeyStore() {
            return (KeyStore)ThrowingSupplier.of(this.sslStoreProvider::getKeyStore).get();
        }

        @Override
        public String getKeyStorePassword() {
            return null;
        }

        @Override
        public KeyStore getTrustStore() {
            return (KeyStore)ThrowingSupplier.of(this.sslStoreProvider::getTrustStore).get();
        }
    }
}

