/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import io.netty.handler.ssl.ClientAuth;
import javax.net.ssl.KeyManagerFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Ssl;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;
import reactor.netty.tcp.SslProvider;

public class SslServerCustomizer
implements NettyServerCustomizer {
    private final Http2 http2;
    private final Ssl.ClientAuth clientAuth;
    private final SslBundle sslBundle;

    public SslServerCustomizer(Http2 http2, Ssl.ClientAuth clientAuth, SslBundle sslBundle) {
        this.http2 = http2;
        this.clientAuth = clientAuth;
        this.sslBundle = sslBundle;
    }

    @Override
    public HttpServer apply(HttpServer server) {
        AbstractProtocolSslContextSpec<?> sslContextSpec = this.createSslContextSpec();
        return server.secure(spec -> spec.sslContext((SslProvider.ProtocolSslContextSpec)sslContextSpec));
    }

    protected AbstractProtocolSslContextSpec<?> createSslContextSpec() {
        Http11SslContextSpec sslContextSpec = this.http2 != null && this.http2.isEnabled() ? Http2SslContextSpec.forServer((KeyManagerFactory)this.sslBundle.getManagers().getKeyManagerFactory()) : Http11SslContextSpec.forServer((KeyManagerFactory)this.sslBundle.getManagers().getKeyManagerFactory());
        sslContextSpec.configure(builder -> {
            builder.trustManager(this.sslBundle.getManagers().getTrustManagerFactory());
            SslOptions options = this.sslBundle.getOptions();
            builder.protocols(options.getEnabledProtocols());
            builder.ciphers(SslOptions.asSet(options.getCiphers()));
            builder.clientAuth(Ssl.ClientAuth.map(this.clientAuth, ClientAuth.NONE, ClientAuth.OPTIONAL, ClientAuth.REQUIRE));
        });
        return sslContextSpec;
    }
}

