/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.Console;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.springframework.util.ClassUtils;

public enum JavaVersion {
    SEVENTEEN("17", Console.class, "charset"),
    EIGHTEEN("18", Duration.class, "isPositive"),
    NINETEEN("19", Future.class, "state"),
    TWENTY("20", Class.class, "accessFlags");

    private final String name;
    private final boolean available;

    private JavaVersion(String name, Class<?> clazz, String methodName) {
        this.name = name;
        this.available = ClassUtils.hasMethod(clazz, (String)methodName, (Class[])new Class[0]);
    }

    public String toString() {
        return this.name;
    }

    public static JavaVersion getJavaVersion() {
        List<JavaVersion> candidates = Arrays.asList(JavaVersion.values());
        Collections.reverse(candidates);
        for (JavaVersion candidate : candidates) {
            if (!candidate.available) continue;
            return candidate;
        }
        return SEVENTEEN;
    }

    public boolean isEqualOrNewerThan(JavaVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isOlderThan(JavaVersion version) {
        return this.compareTo(version) < 0;
    }
}

