/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.time.Duration;
import org.springframework.boot.ssl.SslBundle;

public record ClientHttpRequestFactorySettings(Duration connectTimeout, Duration readTimeout, Boolean bufferRequestBody, SslBundle sslBundle) {
    public static final ClientHttpRequestFactorySettings DEFAULTS = new ClientHttpRequestFactorySettings(null, null, null, null);

    public ClientHttpRequestFactorySettings(Duration connectTimeout, Duration readTimeout, Boolean bufferRequestBody) {
        this(connectTimeout, readTimeout, bufferRequestBody, null);
    }

    public ClientHttpRequestFactorySettings withConnectTimeout(Duration connectTimeout) {
        return new ClientHttpRequestFactorySettings(connectTimeout, this.readTimeout, this.bufferRequestBody, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withReadTimeout(Duration readTimeout) {
        return new ClientHttpRequestFactorySettings(this.connectTimeout, readTimeout, this.bufferRequestBody, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withBufferRequestBody(Boolean bufferRequestBody) {
        return new ClientHttpRequestFactorySettings(this.connectTimeout, this.readTimeout, bufferRequestBody, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withSslBundle(SslBundle sslBundle) {
        return new ClientHttpRequestFactorySettings(this.connectTimeout, this.readTimeout, this.bufferRequestBody, sslBundle);
    }
}

