/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.yaml.SpringProfileDocumentMatcher;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

public class YamlPropertySourceLoader
implements PropertySourceLoader {
    @Override
    public String[] getFileExtensions() {
        return new String[]{"yml", "yaml"};
    }

    @Override
    public PropertySource<?> load(String name, Resource resource, String profile) throws IOException {
        Processor processor;
        Map<String, Object> source;
        if (ClassUtils.isPresent((String)"org.yaml.snakeyaml.Yaml", null) && !(source = (processor = new Processor(resource, profile)).process()).isEmpty()) {
            return new MapPropertySource(name, source);
        }
        return null;
    }

    private static class Processor
    extends YamlProcessor {
        public Processor(Resource resource, String profile) {
            if (profile == null) {
                this.setMatchDefault(true);
                this.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new SpringProfileDocumentMatcher()});
            } else {
                this.setMatchDefault(false);
                this.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{new SpringProfileDocumentMatcher(profile)});
            }
            this.setResources(new Resource[]{resource});
        }

        public Map<String, Object> process() {
            final LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.process(new YamlProcessor.MatchCallback(){

                public void process(Properties properties, Map<String, Object> map) {
                    result.putAll(Processor.this.getFlattenedMap(map));
                }
            });
            return result;
        }
    }
}

