/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.SimpleRequestExpectationManager;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;

public class MockServerRestClientCustomizer
implements RestClientCustomizer {
    private final Map<RestClient.Builder, RequestExpectationManager> expectationManagers = new ConcurrentHashMap<RestClient.Builder, RequestExpectationManager>();
    private final Map<RestClient.Builder, MockRestServiceServer> servers = new ConcurrentHashMap<RestClient.Builder, MockRestServiceServer>();
    private final Supplier<? extends RequestExpectationManager> expectationManagerSupplier;
    private boolean bufferContent = false;

    public MockServerRestClientCustomizer() {
        this(SimpleRequestExpectationManager::new);
    }

    public MockServerRestClientCustomizer(Class<? extends RequestExpectationManager> expectationManager) {
        this(() -> (RequestExpectationManager)BeanUtils.instantiateClass((Class)expectationManager));
        Assert.notNull(expectationManager, (String)"ExpectationManager must not be null");
    }

    public MockServerRestClientCustomizer(Supplier<? extends RequestExpectationManager> expectationManagerSupplier) {
        Assert.notNull(expectationManagerSupplier, (String)"ExpectationManagerSupplier must not be null");
        this.expectationManagerSupplier = expectationManagerSupplier;
    }

    public void setBufferContent(boolean bufferContent) {
        this.bufferContent = bufferContent;
    }

    public void customize(RestClient.Builder restClientBuilder) {
        RequestExpectationManager expectationManager = this.createExpectationManager();
        MockRestServiceServer.MockRestServiceServerBuilder serverBuilder = MockRestServiceServer.bindTo((RestClient.Builder)restClientBuilder);
        if (this.bufferContent) {
            serverBuilder.bufferContent();
        }
        MockRestServiceServer server = serverBuilder.build(expectationManager);
        this.expectationManagers.put(restClientBuilder, expectationManager);
        this.servers.put(restClientBuilder, server);
    }

    protected RequestExpectationManager createExpectationManager() {
        return this.expectationManagerSupplier.get();
    }

    public MockRestServiceServer getServer() {
        Assert.state((!this.servers.isEmpty() ? 1 : 0) != 0, (String)"Unable to return a single MockRestServiceServer since MockServerRestClientCustomizer has not been bound to a RestClient");
        Assert.state((this.servers.size() == 1 ? 1 : 0) != 0, (String)"Unable to return a single MockRestServiceServer since MockServerRestClientCustomizer has been bound to more than one RestClient");
        return this.servers.values().iterator().next();
    }

    public Map<RestClient.Builder, RequestExpectationManager> getExpectationManagers() {
        return this.expectationManagers;
    }

    public MockRestServiceServer getServer(RestClient.Builder restClientBuilder) {
        return this.servers.get(restClientBuilder);
    }

    public Map<RestClient.Builder, MockRestServiceServer> getServers() {
        return Collections.unmodifiableMap(this.servers);
    }
}

