/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactFeatureFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.JavaExecutable;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.RunArguments;

@Mojo(name="run", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class RunMojo
extends AbstractDependencyFilterMojo {
    private static final String SPRING_LOADED_AGENT_CLASSNAME = "org.springsource.loaded.agent.SpringLoadedAgent";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="run.addResources", defaultValue="true")
    private boolean addResources;
    @Parameter(property="run.agent")
    private File[] agent;
    @Parameter(property="run.noverify")
    private Boolean noverify;
    @Parameter(property="run.jvmArguments")
    private String jvmArguments;
    @Parameter(property="run.arguments")
    private String[] arguments;
    @Parameter
    private String mainClass;
    @Parameter
    private String[] folders;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String startClassName = this.getStartClass();
        this.run(startClassName);
    }

    private void findAgent() {
        try {
            Class<?> loaded;
            if ((this.agent == null || this.agent.length == 0) && (loaded = Class.forName(SPRING_LOADED_AGENT_CLASSNAME)) != null) {
                CodeSource source;
                if (this.noverify == null) {
                    this.noverify = true;
                }
                if ((source = loaded.getProtectionDomain().getCodeSource()) != null) {
                    this.agent = new File[]{new File(source.getLocation().getFile())};
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.noverify == null) {
            this.noverify = false;
        }
    }

    private void run(String startClassName) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        this.addAgents(args);
        this.addJvmArgs(args);
        this.addClasspath(args);
        args.add(startClassName);
        this.addArgs(args);
        try {
            new RunProcess(new String[]{new JavaExecutable().toString()}).run(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not exec java", e);
        }
    }

    private void addAgents(List<String> args) {
        this.findAgent();
        if (this.agent != null) {
            this.getLog().info((CharSequence)("Attaching agents: " + Arrays.asList(this.agent)));
            for (File agent : this.agent) {
                args.add("-javaagent:" + agent);
            }
        }
        if (this.noverify.booleanValue()) {
            args.add("-noverify");
        }
    }

    private void addJvmArgs(List<String> args) {
        RunArguments jvmArguments = new RunArguments(this.jvmArguments);
        Collections.addAll(args, jvmArguments.asArray());
        this.logArguments("JVM argument(s): ", jvmArguments.asArray());
    }

    private void addClasspath(List<String> args) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.getClassPathUrls()) {
                classpath = classpath.append((classpath.length() > 0 ? File.pathSeparator : "") + new File(ele.toURI()));
            }
            this.getLog().debug((CharSequence)("Classpath for forked process: " + classpath));
            args.add("-cp");
            args.add(classpath.toString());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not build classpath", e);
        }
    }

    private void addArgs(List<String> args) {
        Collections.addAll(args, this.arguments);
        this.logArguments("Application argument(s): ", this.arguments);
    }

    private final String getStartClass() throws MojoExecutionException {
        String mainClass = this.mainClass;
        if (mainClass == null) {
            try {
                mainClass = MainClassFinder.findSingleMainClass((File)this.classesDirectory);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        if (mainClass == null) {
            throw new MojoExecutionException("Unable to find a suitable main class, please add a 'mainClass' property");
        }
        return mainClass;
    }

    private URL[] getClassPathUrls() throws MojoExecutionException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.addUserDefinedFolders(urls);
            this.addResources(urls);
            this.addProjectClasses(urls);
            this.addDependencies(urls);
            return urls.toArray(new URL[urls.size()]);
        }
        catch (MalformedURLException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
    }

    private void addUserDefinedFolders(List<URL> urls) throws MalformedURLException {
        if (this.folders != null) {
            for (String folder : this.folders) {
                urls.add(new File(folder).toURI().toURL());
            }
        }
    }

    private void addResources(List<URL> urls) throws IOException {
        if (this.addResources) {
            for (Resource resource : this.project.getResources()) {
                File directory = new File(resource.getDirectory());
                urls.add(directory.toURI().toURL());
                FileUtils.removeDuplicatesFromOutputDirectory((File)this.classesDirectory, (File)directory);
            }
        }
    }

    private void addProjectClasses(List<URL> urls) throws MalformedURLException {
        urls.add(this.classesDirectory.toURI().toURL());
    }

    private void addDependencies(List<URL> urls) throws MalformedURLException, MojoExecutionException {
        FilterArtifacts filters = this.getFilters(new ArtifactsFilter[]{new TestArtifactFilter()});
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), filters);
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
    }

    private void logArguments(String message, String[] args) {
        StringBuffer sb = new StringBuffer(message);
        for (String arg : args) {
            sb.append(arg).append(" ");
        }
        this.getLog().debug((CharSequence)sb.toString().trim());
    }

    private static class TestArtifactFilter
    extends AbstractArtifactFeatureFilter {
        public TestArtifactFilter() {
            super("", "test");
        }

        protected String getArtifactFeature(Artifact artifact) {
            return artifact.getScope();
        }
    }
}

