/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class ZipFileTarArchive
implements TarArchive {
    static final long NORMALIZED_MOD_TIME = TarArchive.NORMALIZED_TIME.toEpochMilli();
    private final File zip;
    private final Owner owner;

    public ZipFileTarArchive(File zip, Owner owner) {
        Assert.notNull((Object)zip, (String)"Zip must not be null");
        Assert.notNull((Object)owner, (String)"Owner must not be null");
        this.assertArchiveHasEntries(zip);
        this.zip = zip;
        this.owner = owner;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        TarArchiveOutputStream tar = new TarArchiveOutputStream(outputStream);
        tar.setLongFileMode(3);
        try (ZipFile zipFile = new ZipFile(this.zip);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
                this.copy(zipEntry, zipFile.getInputStream(zipEntry), tar);
            }
        }
        tar.finish();
    }

    private void assertArchiveHasEntries(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Assert.state((boolean)zipFile.getEntries().hasMoreElements(), () -> "Archive file '" + file + "' is not valid");
        }
        catch (IOException ex) {
            throw new IllegalStateException("File '" + file + "' is not readable", ex);
        }
    }

    private void copy(ZipArchiveEntry zipEntry, InputStream zip, TarArchiveOutputStream tar) throws IOException {
        TarArchiveEntry tarEntry = this.convert(zipEntry);
        tar.putArchiveEntry(tarEntry);
        if (tarEntry.isFile()) {
            StreamUtils.copyRange((InputStream)zip, (OutputStream)tar, (long)0L, (long)tarEntry.getSize());
        }
        tar.closeArchiveEntry();
    }

    private TarArchiveEntry convert(ZipArchiveEntry zipEntry) {
        byte linkFlag = zipEntry.isDirectory() ? (byte)53 : 48;
        TarArchiveEntry tarEntry = new TarArchiveEntry(zipEntry.getName(), linkFlag, true);
        tarEntry.setUserId(this.owner.getUid());
        tarEntry.setGroupId(this.owner.getGid());
        tarEntry.setModTime(NORMALIZED_MOD_TIME);
        tarEntry.setMode(zipEntry.getUnixMode());
        if (!zipEntry.isDirectory()) {
            tarEntry.setSize(zipEntry.getSize());
        }
        return tarEntry;
    }
}

