/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.mongo;

import com.mongodb.client.MongoClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoDbFactorySupport;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

@Configuration
@ConditionalOnMissingBean(value={MongoDbFactory.class})
@Conditional(value={AnyMongoClientAvailable.class})
class MongoDbFactoryConfiguration {
    MongoDbFactoryConfiguration() {
    }

    @Bean
    public MongoDbFactorySupport<?> mongoDbFactory(ObjectProvider<com.mongodb.MongoClient> mongo, ObjectProvider<MongoClient> mongoClient, MongoProperties properties) {
        com.mongodb.MongoClient preferredClient = (com.mongodb.MongoClient)mongo.getIfAvailable();
        if (preferredClient != null) {
            return new SimpleMongoDbFactory(preferredClient, properties.getMongoClientDatabase());
        }
        MongoClient fallbackClient = (MongoClient)mongoClient.getIfAvailable();
        if (fallbackClient != null) {
            return new SimpleMongoClientDbFactory(fallbackClient, properties.getMongoClientDatabase());
        }
        throw new IllegalStateException("Expected to find at least one MongoDB client.");
    }

    static class AnyMongoClientAvailable
    extends AnyNestedCondition {
        AnyMongoClientAvailable() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={MongoClient.class})
        static class FallbackClientAvailable {
            FallbackClientAvailable() {
            }
        }

        @ConditionalOnBean(value={com.mongodb.MongoClient.class})
        static class PreferredClientAvailable {
            PreferredClientAvailable() {
            }
        }
    }
}

