/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public final class SanitizableData {
    public static final String SANITIZED_VALUE = "******";
    private final @Nullable PropertySource<?> propertySource;
    private final String key;
    private @Nullable String lowerCaseKey;
    private final @Nullable Object value;

    public SanitizableData(@Nullable PropertySource<?> propertySource, String key, @Nullable Object value) {
        Assert.notNull((Object)key, (String)"'key' must not be null");
        this.propertySource = propertySource;
        this.key = key;
        this.value = value;
    }

    public @Nullable PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    public String getKey() {
        return this.key;
    }

    public String getLowerCaseKey() {
        String result = this.lowerCaseKey;
        if (result == null) {
            this.lowerCaseKey = result = this.key.toLowerCase(Locale.getDefault());
        }
        return result;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public SanitizableData withSanitizedValue() {
        return this.withValue(SANITIZED_VALUE);
    }

    public SanitizableData withValue(@Nullable Object value) {
        return new SanitizableData(this.propertySource, this.key, value);
    }
}

