/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthWebEndpointResponseMapper;
import org.springframework.boot.actuate.health.ShowDetails;

@EndpointWebExtension(endpoint=HealthEndpoint.class)
public class HealthEndpointWebExtension {
    private final HealthIndicator delegate;
    private final HealthWebEndpointResponseMapper responseMapper;

    public HealthEndpointWebExtension(HealthIndicator delegate, HealthWebEndpointResponseMapper responseMapper) {
        this.delegate = delegate;
        this.responseMapper = responseMapper;
    }

    @ReadOperation
    public WebEndpointResponse<Health> getHealth(SecurityContext securityContext) {
        return this.responseMapper.map(this.delegate.health(), securityContext);
    }

    public WebEndpointResponse<Health> getHealth(SecurityContext securityContext, ShowDetails showDetails) {
        return this.responseMapper.map(this.delegate.health(), securityContext, showDetails);
    }
}

