/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.property;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.SetterFactoryProperty;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;

public class IndexedSetterProperty
extends SetterFactoryProperty {
    private final IndexedSetter<?, ?> setter;

    public <P> IndexedSetterProperty(final IndexedSetter<PreparedStatement, P> setter) {
        super((SetterFactory)new SetterFactory<PreparedStatement, Object>(){

            public <PP> Setter<PreparedStatement, PP> getSetter(Object arg) {
                final int index = ((PropertyMapping)arg).getColumnKey().getIndex();
                return new Setter<PreparedStatement, PP>(){

                    public void set(PreparedStatement target, PP value) throws Exception {
                        setter.set((Object)target, value, index);
                    }
                };
            }
        }, PreparedStatement.class);
        this.setter = setter;
    }

    public static <T> IndexedSetterProperty of(final PreparedStatementSetter<T> setter) {
        return new IndexedSetterProperty(new IndexedSetter<PreparedStatement, T>(){

            public void set(PreparedStatement target, T value, int index) throws Exception {
                setter.set(target, index, value);
            }
        });
    }

    public IndexedSetter<?, ?> getIndexedSetter() {
        return this.setter;
    }

    public String toString() {
        return "IndexedSetter{IndexedSetter}";
    }

    public static interface PreparedStatementSetter<T> {
        public void set(PreparedStatement var1, int var2, T var3) throws SQLException;
    }
}

