/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.named;

import java.util.ArrayList;
import org.simpleflatmapper.jdbc.SizeSupplier;
import org.simpleflatmapper.jdbc.named.NamedParameter;
import org.simpleflatmapper.jdbc.named.NamedSqlQueryParser;
import org.simpleflatmapper.jdbc.named.ParameterizedQuery;
import org.simpleflatmapper.util.Asserts;

public class NamedSqlQuery
implements ParameterizedQuery {
    private static final SizeSupplier DEFAULT_SIZE_SUPPLIER = new SizeSupplier(){

        @Override
        public int getSize(int columnIndex) {
            return 1;
        }
    };
    private final String sql;
    private final NamedParameter[] parameters;

    private NamedSqlQuery(String sql, NamedParameter[] parameters) {
        this.sql = (String)Asserts.requireNonNull((String)"sql", (Object)sql);
        this.parameters = (NamedParameter[])Asserts.requireNonNull((String)"parameters", (Object)parameters);
    }

    public static NamedSqlQuery parse(CharSequence charSequence) {
        Asserts.requireNonNull((String)"charSequence", (Object)charSequence);
        final ArrayList sqlParameters = new ArrayList();
        new NamedSqlQueryParser(new NamedSqlQueryParser.Callback(){

            @Override
            public void param(NamedParameter namedParameter) {
                sqlParameters.add(namedParameter);
            }
        }).parse(charSequence);
        return new NamedSqlQuery(charSequence.toString(), sqlParameters.toArray(new NamedParameter[0]));
    }

    public String toSqlQuery() {
        return this.toSqlQuery(DEFAULT_SIZE_SUPPLIER);
    }

    public String toSqlQuery(SizeSupplier sizeSupplier) {
        StringBuilder sb = new StringBuilder(this.sql.length());
        int start = 0;
        for (int i = 0; i < this.parameters.length; ++i) {
            NamedParameter sqlParameter = this.parameters[i];
            sb.append(this.sql, start, sqlParameter.getPosition().getStart());
            this.appendParam(sizeSupplier, sb, i);
            start = sqlParameter.getPosition().getEnd();
        }
        sb.append(this.sql, start, this.sql.length());
        return sb.toString();
    }

    public void appendParam(SizeSupplier sizeSupplier, StringBuilder sb, int index) {
        int size = sizeSupplier.getSize(index);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("?");
        }
    }

    @Override
    public int getParametersSize() {
        return this.parameters.length;
    }

    @Override
    public NamedParameter getParameter(int i) {
        return this.parameters[i];
    }
}

