/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl.getter;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.Arrays;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.reflect.Getter;

public class ArrayBooleanResultSetGetter
implements Getter<ResultSet, boolean[]>,
ContextualGetter<ResultSet, boolean[]> {
    private static final boolean[] INIT = new boolean[0];
    private final int index;

    public ArrayBooleanResultSetGetter(int index) {
        this.index = index;
    }

    public boolean[] get(ResultSet resultSet, Context context) throws Exception {
        return this.get(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] get(ResultSet target) throws Exception {
        Array sqlArray = target.getArray(this.index);
        if (sqlArray != null) {
            boolean[] array = INIT;
            int capacity = 0;
            int size = 0;
            try (ResultSet rs = sqlArray.getResultSet();){
                while (rs.next()) {
                    if (size >= capacity) {
                        int newCapacity = Math.max(Math.max(capacity + 1, capacity + (capacity >> 1)), 10);
                        array = Arrays.copyOf(array, newCapacity);
                        capacity = newCapacity;
                    }
                    array[size++] = rs.getBoolean(2);
                }
            }
            return Arrays.copyOf(array, size);
        }
        return null;
    }
}

