/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Quotes;
import org.openqa.selenium.support.ui.UnexpectedTagNameException;

public class Select {
    private final WebElement element;
    private final boolean isMulti;

    public Select(WebElement element) {
        String tagName = element.getTagName();
        if (null == tagName || !"select".equals(tagName.toLowerCase())) {
            throw new UnexpectedTagNameException("select", tagName);
        }
        this.element = element;
        String value = element.getAttribute("multiple");
        this.isMulti = value != null && !"false".equals(value);
    }

    public boolean isMultiple() {
        return this.isMulti;
    }

    public List<WebElement> getOptions() {
        return this.element.findElements(By.tagName((String)"option"));
    }

    public List<WebElement> getAllSelectedOptions() {
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            toReturn.add(option);
        }
        return toReturn;
    }

    public WebElement getFirstSelectedOption() {
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            return option;
        }
        throw new NoSuchElementException("No options are selected");
    }

    public void selectByVisibleText(String text) {
        List options = this.element.findElements(By.xpath((String)(".//option[normalize-space(.) = " + Quotes.escape(text) + "]")));
        boolean matched = false;
        for (WebElement option : options) {
            this.setSelected(option);
            if (!this.isMultiple()) {
                return;
            }
            matched = true;
        }
        if (options.isEmpty() && text.contains(" ")) {
            String subStringWithoutSpace = this.getLongestSubstringWithoutSpace(text);
            List candidates = "".equals(subStringWithoutSpace) ? this.element.findElements(By.tagName((String)"option")) : this.element.findElements(By.xpath((String)(".//option[contains(., " + Quotes.escape(subStringWithoutSpace) + ")]")));
            for (WebElement option : candidates) {
                if (!text.equals(option.getText())) continue;
                this.setSelected(option);
                if (!this.isMultiple()) {
                    return;
                }
                matched = true;
            }
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate element with text: " + text);
        }
    }

    private String getLongestSubstringWithoutSpace(String s) {
        String result = "";
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.length() <= result.length()) continue;
            result = t;
        }
        return result;
    }

    public void selectByIndex(int index) {
        String match = String.valueOf(index);
        boolean matched = false;
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index"))) continue;
            this.setSelected(option);
            if (!this.isMultiple()) {
                return;
            }
            matched = true;
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate option with index: " + index);
        }
    }

    public void selectByValue(String value) {
        List options = this.element.findElements(By.xpath((String)(".//option[@value = " + Quotes.escape(value) + "]")));
        boolean matched = false;
        for (WebElement option : options) {
            this.setSelected(option);
            if (!this.isMultiple()) {
                return;
            }
            matched = true;
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate option with value: " + value);
        }
    }

    public void deselectAll() {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect all options of a multi-select");
        }
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    public void deselectByValue(String value) {
        List options = this.element.findElements(By.xpath((String)(".//option[@value = " + Quotes.escape(value) + "]")));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    public void deselectByIndex(int index) {
        String match = String.valueOf(index);
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index")) || !option.isSelected()) continue;
            option.click();
        }
    }

    public void deselectByVisibleText(String text) {
        List options = this.element.findElements(By.xpath((String)(".//option[normalize-space(.) = " + Quotes.escape(text) + "]")));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    private void setSelected(WebElement option) {
        if (!option.isSelected()) {
            option.click();
        }
    }
}

