/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.commands.Command;

public class SeleniumCoreCommand
extends Command {
    public static final String CAPTURE_ENTIRE_PAGE_SCREENSHOT_ID = "captureEntirePageScreenshot";
    public static final String GET_HTML_SOURCE_ID = "getHtmlSource";
    private static final Logger log = Logger.getLogger(SeleniumCoreCommand.class.getName());
    private final String id;
    private final List<String> values;
    private final String sessionId;

    public SeleniumCoreCommand(String id, List<String> values, String sessionId) {
        this.id = id;
        this.values = values;
        this.sessionId = sessionId;
    }

    @Override
    public String execute() {
        log.fine("Executing '" + this.id + "' selenium core command on session " + this.sessionId);
        try {
            log.fine("Session " + this.sessionId + " going to doCommand(" + this.id + ',' + this.values.get(0) + ',' + this.values.get(1) + ")");
            FrameGroupCommandQueueSet queue = FrameGroupCommandQueueSet.getQueueSet(this.sessionId);
            String response = queue.doCommand(this.id, this.values.get(0), this.values.get(1));
            log.fine("Got result: " + response + " on session " + this.sessionId);
            return response;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception running '" + this.id + " 'command on session " + this.sessionId, e);
            return "ERROR Server Exception: " + e.getMessage();
        }
    }
}

