/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;

public class CustomBrowserLauncher
extends AbstractBrowserLauncher {
    protected CommandLine process;
    protected String commandPath;

    public CustomBrowserLauncher(String commandPath, String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        super(sessionId, configuration, browserOptions);
        this.commandPath = commandPath;
        this.sessionId = sessionId;
    }

    public void close() {
        if (this.process == null) {
            return;
        }
        this.process.destroy();
    }

    protected void launch(String url) {
        this.exec(this.commandPath + " " + url);
    }

    protected void exec(String command) {
        try {
            this.process = new CommandLine(command, new String[0]);
            this.process.executeAsync();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error starting browser by executing command " + command + ": " + e);
        }
    }
}

