/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.util.concurrent.TimeUnit;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    private final DefaultHttpClient httpClient;
    private final DefaultHttpClient gridClient;
    private final int TIMEOUT_THREE_HOURS = (int)TimeUnit.HOURS.toMillis(3L);

    public HttpClientFactory() {
        this.httpClient = new DefaultHttpClient(HttpClientFactory.getClientConnectionManager());
        this.httpClient.setParams(this.getHttpParams());
        this.gridClient = new DefaultHttpClient(HttpClientFactory.getClientConnectionManager());
        this.gridClient.setRedirectStrategy((RedirectStrategy)new MyRedirectHandler());
        this.gridClient.setParams(this.getGridHttpParams());
        this.gridClient.getConnectionManager().closeIdleConnections(100L, TimeUnit.MILLISECONDS);
    }

    private static ClientConnectionManager getClientConnectionManager() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(registry);
        cm.setMaxTotal(2000);
        cm.setDefaultMaxPerRoute(2000);
        return cm;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpClient getGridHttpClient() {
        return this.gridClient;
    }

    public HttpParams getHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setSoReuseaddr((HttpParams)params, (boolean)true);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)120000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.TIMEOUT_THREE_HOURS);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)true);
        return params;
    }

    public HttpParams getGridHttpParams() {
        HttpParams params = this.getHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.TIMEOUT_THREE_HOURS);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)120000);
        return params;
    }

    public void close() {
        this.httpClient.getConnectionManager().shutdown();
        this.gridClient.getConnectionManager().shutdown();
    }

    static class MyRedirectHandler
    implements RedirectStrategy {
        MyRedirectHandler() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    }
}

