/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import org.openqa.selenium.WebDriver;

public class Timer {
    private volatile long timeout;
    private boolean stopped;

    public Timer(long timeout) {
        this.timeout = timeout;
    }

    public <T> T run(SeleneseCommand<T> command, WebDriver driver, String[] args) {
        if (this.stopped) {
            throw new IllegalStateException("Timer has already been stopped");
        }
        command.setDefaultTimeout(this.timeout);
        long start = System.currentTimeMillis();
        T value = command.apply(driver, args);
        long duration = System.currentTimeMillis() - start;
        if (duration > this.timeout) {
            throw new SeleniumException("Timed out waiting for action to finish");
        }
        return value;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void stop() {
        this.stopped = true;
    }
}

