/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Set;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.Session;
import org.openqa.selenium.grid.graphql.SessionNotFoundException;
import org.openqa.selenium.internal.Require;

public class SessionData
implements DataFetcher<Session> {
    private final Distributor distributor;

    public SessionData(Distributor distributor) {
        this.distributor = (Distributor)Require.nonNull((String)"Distributor", (Object)distributor);
    }

    public Session get(DataFetchingEnvironment environment) {
        String sessionId = (String)environment.getArgument("id");
        if (sessionId == null || sessionId.isEmpty()) {
            throw new SessionNotFoundException("Session id is empty. A valid session id is required.");
        }
        Set<NodeStatus> nodeStatuses = this.distributor.getStatus().getNodes();
        SessionInSlot currentSession = this.findSession(sessionId, nodeStatuses);
        if (currentSession != null) {
            org.openqa.selenium.grid.data.Session session = currentSession.session;
            return new Session(session.getId().toString(), session.getCapabilities(), session.getStartTime(), session.getUri(), currentSession.node.getNodeId().toString(), currentSession.node.getExternalUri(), currentSession.slot);
        }
        throw new SessionNotFoundException("No ongoing session found with the requested session id.", sessionId);
    }

    private SessionInSlot findSession(String sessionId, Set<NodeStatus> nodeStatuses) {
        for (NodeStatus status : nodeStatuses) {
            for (Slot slot : status.getSlots()) {
                org.openqa.selenium.grid.data.Session session = slot.getSession();
                if (session == null || !sessionId.equals(session.getId().toString())) continue;
                return new SessionInSlot(session, status, slot);
            }
        }
        return null;
    }

    private static class SessionInSlot {
        private final org.openqa.selenium.grid.data.Session session;
        private final NodeStatus node;
        private final Slot slot;

        SessionInSlot(org.openqa.selenium.grid.data.Session session, NodeStatus node, Slot slot) {
            this.session = session;
            this.node = node;
            this.slot = slot;
        }
    }
}

