/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.WebDriverInfo;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

@AutoService(value={WebDriverInfo.class})
public class GeckoDriverInfo
implements WebDriverInfo {
    private static final Logger LOG = Logger.getLogger(GeckoDriverInfo.class.getName());

    public String getDisplayName() {
        return "Firefox";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)Browser.FIREFOX.browserName());
    }

    public boolean isSupporting(Capabilities capabilities) {
        if (Browser.FIREFOX.is(capabilities)) {
            return true;
        }
        return capabilities.asMap().keySet().stream().anyMatch(key -> key.startsWith("moz:"));
    }

    public boolean isSupportingCdp() {
        return false;
    }

    public boolean isSupportingBiDi() {
        return true;
    }

    public boolean isAvailable() {
        return new DriverFinder((DriverService)GeckoDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    public boolean isPresent() {
        return new DriverFinder((DriverService)GeckoDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors();
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities, ClientConfig clientConfig) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new FirefoxDriver(new FirefoxOptions().merge(capabilities), clientConfig));
    }
}

