/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.storage.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v132.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v132.storage.model.InterestGroupAccessType;
import org.openqa.selenium.devtools.v132.storage.model.InterestGroupAuctionId;
import org.openqa.selenium.json.JsonInput;

public class InterestGroupAccessed {
    private final TimeSinceEpoch accessTime;
    private final InterestGroupAccessType type;
    private final String ownerOrigin;
    private final String name;
    private final Optional<String> componentSellerOrigin;
    private final Optional<Number> bid;
    private final Optional<String> bidCurrency;
    private final Optional<InterestGroupAuctionId> uniqueAuctionId;

    public InterestGroupAccessed(TimeSinceEpoch accessTime, InterestGroupAccessType type, String ownerOrigin, String name, Optional<String> componentSellerOrigin, Optional<Number> bid, Optional<String> bidCurrency, Optional<InterestGroupAuctionId> uniqueAuctionId) {
        this.accessTime = Objects.requireNonNull(accessTime, "accessTime is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.ownerOrigin = Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.componentSellerOrigin = componentSellerOrigin;
        this.bid = bid;
        this.bidCurrency = bidCurrency;
        this.uniqueAuctionId = uniqueAuctionId;
    }

    public TimeSinceEpoch getAccessTime() {
        return this.accessTime;
    }

    public InterestGroupAccessType getType() {
        return this.type;
    }

    public String getOwnerOrigin() {
        return this.ownerOrigin;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getComponentSellerOrigin() {
        return this.componentSellerOrigin;
    }

    public Optional<Number> getBid() {
        return this.bid;
    }

    public Optional<String> getBidCurrency() {
        return this.bidCurrency;
    }

    public Optional<InterestGroupAuctionId> getUniqueAuctionId() {
        return this.uniqueAuctionId;
    }

    private static InterestGroupAccessed fromJson(JsonInput input) {
        TimeSinceEpoch accessTime = null;
        InterestGroupAccessType type = null;
        String ownerOrigin = null;
        String name = null;
        Optional<String> componentSellerOrigin = Optional.empty();
        Optional<Number> bid = Optional.empty();
        Optional<String> bidCurrency = Optional.empty();
        Optional<InterestGroupAuctionId> uniqueAuctionId = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "accessTime": {
                    accessTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block20;
                }
                case "type": {
                    type = (InterestGroupAccessType)((Object)input.read(InterestGroupAccessType.class));
                    continue block20;
                }
                case "ownerOrigin": {
                    ownerOrigin = input.nextString();
                    continue block20;
                }
                case "name": {
                    name = input.nextString();
                    continue block20;
                }
                case "componentSellerOrigin": {
                    componentSellerOrigin = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "bid": {
                    bid = Optional.ofNullable(input.nextNumber());
                    continue block20;
                }
                case "bidCurrency": {
                    bidCurrency = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "uniqueAuctionId": {
                    uniqueAuctionId = Optional.ofNullable((InterestGroupAuctionId)input.read(InterestGroupAuctionId.class));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InterestGroupAccessed(accessTime, type, ownerOrigin, name, componentSellerOrigin, bid, bidCurrency, uniqueAuctionId);
    }
}

