/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.internal.BuildInfo;

public class WebDriverException
extends RuntimeException {
    public static final String SESSION_ID = "Session ID";
    public static final String DRIVER_INFO = "Driver info";
    private Map<String, String> extraInfo = new HashMap<String, String>();

    public WebDriverException() {
    }

    public WebDriverException(String message) {
        super(message);
    }

    public WebDriverException(Throwable cause) {
        super(cause);
    }

    public WebDriverException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return this.createMessage(super.getMessage());
    }

    private String createMessage(String originalMessageString) {
        String supportMessage = this.getSupportUrl() == null ? "" : "For documentation on this error, please visit: " + this.getSupportUrl() + "\n";
        return (originalMessageString == null ? "" : originalMessageString + "\n") + supportMessage + this.getBuildInformation() + "\n" + this.getSystemInformation() + this.getAdditionalInformation();
    }

    public String getSystemInformation() {
        String host = "N/A";
        String ip = "N/A";
        try {
            host = InetAddress.getLocalHost().getHostName();
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return String.format("System info: host: '%s', ip: '%s', os.name: '%s', os.arch: '%s', os.version: '%s', java.version: '%s'", host, ip, System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"));
    }

    public String getSupportUrl() {
        return null;
    }

    public BuildInfo getBuildInformation() {
        return new BuildInfo();
    }

    public static String getDriverName(StackTraceElement[] stackTraceElements) {
        String driverName = "unknown";
        for (StackTraceElement e : stackTraceElements) {
            if (!e.getClassName().endsWith("Driver")) continue;
            String[] bits = e.getClassName().split("\\.");
            driverName = bits[bits.length - 1];
        }
        return driverName;
    }

    public void addInfo(String key, String value) {
        this.extraInfo.put(key, value);
    }

    public String getAdditionalInformation() {
        if (!this.extraInfo.containsKey(DRIVER_INFO)) {
            this.extraInfo.put(DRIVER_INFO, "driver.version: " + WebDriverException.getDriverName(this.getStackTrace()));
        }
        String result = "";
        for (Map.Entry<String, String> entry : this.extraInfo.entrySet()) {
            if (entry.getValue() != null && entry.getValue().startsWith(entry.getKey())) {
                result = result + "\n" + entry.getValue();
                continue;
            }
            result = result + "\n" + entry.getKey() + ": " + entry.getValue();
        }
        return result;
    }
}

