/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Base64Encoder;

public interface OutputType<T> {
    public static final OutputType<String> BASE64 = new OutputType<String>(){

        @Override
        public String convertFromBase64Png(String base64Png) {
            return base64Png;
        }

        @Override
        public String convertFromPngBytes(byte[] png) {
            return new Base64Encoder().encode(png);
        }

        public String toString() {
            return "OutputType.BASE64";
        }
    };
    public static final OutputType<byte[]> BYTES = new OutputType<byte[]>(){

        @Override
        public byte[] convertFromBase64Png(String base64Png) {
            return new Base64Encoder().decode(base64Png);
        }

        @Override
        public byte[] convertFromPngBytes(byte[] png) {
            return png;
        }

        public String toString() {
            return "OutputType.BYTES";
        }
    };
    public static final OutputType<File> FILE = new OutputType<File>(){

        @Override
        public File convertFromBase64Png(String base64Png) {
            return this.save((byte[])BYTES.convertFromBase64Png(base64Png));
        }

        @Override
        public File convertFromPngBytes(byte[] data) {
            return this.save(data);
        }

        private File save(byte[] data) {
            OutputStream stream = null;
            try {
                File tmpFile = File.createTempFile("screenshot", ".png");
                tmpFile.deleteOnExit();
                stream = new FileOutputStream(tmpFile);
                stream.write(data);
                File file = tmpFile;
                return file;
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public String toString() {
            return "OutputType.FILE";
        }
    };

    public T convertFromBase64Png(String var1);

    public T convertFromPngBytes(byte[] var1);
}

