/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers;

import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.browserlaunchers.DoNotUseProxyPac;
import org.openqa.selenium.remote.DesiredCapabilities;

public class Proxies {
    public static final String PROXY_CONFIG = "proxy";

    public static boolean isProxyRequired(Capabilities capabilities) {
        return capabilities.is("proxyRequired") || capabilities.getCapability(PROXY_CONFIG) != null;
    }

    public static File makeProxyPAC(File parentDir, int port, Capabilities capabilities) {
        return Proxies.makeProxyPAC(parentDir, port, System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), System.getProperty("http.nonProxyHosts"), capabilities);
    }

    public static File makeProxyPAC(File parentDir, int port, String configuredProxy, String proxyPort, String nonProxyHosts, Capabilities capabilities) {
        DoNotUseProxyPac pac = Proxies.newProxyPac(port, configuredProxy, proxyPort, nonProxyHosts, capabilities);
        Proxy proxy = Proxies.extractProxy(capabilities);
        if (proxy != null && proxy.getHttpProxy() != null) {
            pac.defaults().toProxy(proxy.getHttpProxy());
        }
        try {
            File pacFile = new File(parentDir, "proxy.pac");
            FileWriter out = new FileWriter(pacFile);
            pac.outputTo(out);
            ((Writer)out).close();
            return pacFile;
        }
        catch (IOException e) {
            throw new SeleniumException("Unable to configure proxy. Selenium will not work.", e);
        }
    }

    public static Proxy extractProxy(Capabilities capabilities) {
        Object rawProxy = capabilities.getCapability(PROXY_CONFIG);
        Proxy proxy = null;
        if (rawProxy != null) {
            if (rawProxy instanceof Proxy) {
                proxy = (Proxy)rawProxy;
            } else if (rawProxy instanceof Map) {
                proxy = new Proxy((Map)rawProxy);
            }
        }
        return proxy;
    }

    static DoNotUseProxyPac newProxyPac(int port, String configuredProxy, String proxyPort, String nonProxyHosts, Capabilities capabilities) {
        Proxy proxy;
        DoNotUseProxyPac existingConfig = (DoNotUseProxyPac)capabilities.getCapability("proxy_pac");
        DoNotUseProxyPac pac = existingConfig == null ? new DoNotUseProxyPac() : existingConfig;
        Object tempProxy = capabilities.getCapability(PROXY_CONFIG);
        if (tempProxy != null && (proxy = Proxies.extractProxy(capabilities)).getHttpProxy() != null) {
            pac.defaults().toProxy(proxy.getHttpProxy());
        }
        if (configuredProxy != null) {
            String proxyToUse = configuredProxy;
            if (proxyPort != null) {
                proxyToUse = proxyToUse + ":" + proxyPort;
            }
            pac.defaults().toProxy(proxyToUse);
        }
        String defaultProxy = "DIRECT";
        if (configuredProxy != null) {
            defaultProxy = "PROXY " + configuredProxy;
            if (proxyPort != null) {
                defaultProxy = defaultProxy + ":" + proxyPort;
            }
        }
        String seleniumServerAsProxy = "localhost:" + port + "; " + defaultProxy;
        if (Proxies.isOnlyProxyingSelenium(capabilities)) {
            pac.map("*/selenium-server/*").toProxy(seleniumServerAsProxy);
            if (nonProxyHosts != null && nonProxyHosts.trim().length() > 0) {
                String[] hosts;
                for (String host : hosts = nonProxyHosts.split("\\|")) {
                    pac.mapHost(host).toNoProxy();
                }
            }
        } else {
            pac.defaults().toProxy(seleniumServerAsProxy);
        }
        return pac;
    }

    public static boolean isProxyingAllTraffic(Capabilities capabilities) {
        return !capabilities.is("onlyProxySeleniumTraffic") || !capabilities.is("avoidProxy") || capabilities.is("proxyEverything");
    }

    public static boolean isOnlyProxyingSelenium(Capabilities capabilities) {
        return !Proxies.isProxyingAllTraffic(capabilities);
    }

    public static Capabilities setProxyEverything(Capabilities source, boolean isProxyingEverything) {
        DesiredCapabilities toReturn = Proxies.newDesiredCapabilities(source);
        toReturn.setCapability("proxyEverything", isProxyingEverything);
        return toReturn;
    }

    public static Capabilities setAvoidProxy(Capabilities source, boolean avoidProxy) {
        DesiredCapabilities toReturn = Proxies.newDesiredCapabilities(source);
        toReturn.setCapability("avoidProxy", avoidProxy);
        return toReturn;
    }

    public static Capabilities setOnlyProxySeleniumTraffic(Capabilities source, boolean onlyProxySeleniumTraffic) {
        DesiredCapabilities toReturn = Proxies.newDesiredCapabilities(source);
        toReturn.setCapability("onlyProxySeleniumTraffic", onlyProxySeleniumTraffic);
        return toReturn;
    }

    public static Capabilities setProxyRequired(Capabilities source, boolean proxyRequired) {
        DesiredCapabilities toReturn = Proxies.newDesiredCapabilities(source);
        toReturn.setCapability("proxyRequired", proxyRequired);
        return toReturn;
    }

    private static DesiredCapabilities newDesiredCapabilities(Capabilities source) {
        if (source instanceof DesiredCapabilities) {
            return (DesiredCapabilities)source;
        }
        return new DesiredCapabilities(source);
    }
}

