/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.tcpunixsocketproxy;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.rnorth.tcpunixsocketproxy.ProxyPump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpToUnixSocketProxy {
    private final String listenHostname;
    private final int listenPort;
    private final File unixSocketFile;
    private ServerSocket listenSocket;
    private static final Logger logger = LoggerFactory.getLogger(ProxyPump.class);
    private Thread acceptThread;
    private boolean running = true;

    public TcpToUnixSocketProxy(File unixSocketFile) {
        if (!unixSocketFile.exists()) {
            throw new IllegalArgumentException("Socket file does not exist: " + unixSocketFile);
        }
        this.listenHostname = "localhost";
        this.listenPort = 0;
        this.unixSocketFile = unixSocketFile;
    }

    public TcpToUnixSocketProxy(String listenHostname, int listenPort, File unixSocketFile) {
        if (!unixSocketFile.exists()) {
            throw new IllegalArgumentException("Socket file does not exist: " + unixSocketFile);
        }
        this.listenHostname = listenHostname;
        this.listenPort = listenPort;
        this.unixSocketFile = unixSocketFile;
    }

    public InetSocketAddress start() throws IOException {
        this.listenSocket = new ServerSocket();
        this.listenSocket.bind(new InetSocketAddress(this.listenHostname, this.listenPort));
        logger.debug("Listening on {} and proxying to {}", (Object)this.listenSocket.getLocalSocketAddress(), (Object)this.unixSocketFile.getAbsolutePath());
        this.acceptThread = new Thread(() -> {
            while (this.running) {
                try {
                    Socket incomingSocket = this.listenSocket.accept();
                    logger.debug("Accepting incoming connection from {}", (Object)incomingSocket.getRemoteSocketAddress());
                    AFUNIXSocket outgoingSocket = AFUNIXSocket.newInstance();
                    outgoingSocket.connect((SocketAddress)new AFUNIXSocketAddress(this.unixSocketFile));
                    new ProxyPump(incomingSocket, (Socket)outgoingSocket);
                }
                catch (IOException iOException) {}
            }
        });
        this.acceptThread.setDaemon(true);
        this.acceptThread.setName("tcp-unix-proxy-accept-thread");
        this.acceptThread.start();
        return (InetSocketAddress)this.listenSocket.getLocalSocketAddress();
    }

    public void stop() {
        try {
            this.running = false;
            this.listenSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

