/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.el;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.richfaces.el.CapturingELContext;
import org.richfaces.el.ValueDescriptor;
import org.richfaces.el.ValueExpressionAnalayser;
import org.richfaces.validator.GraphValidatorState;

public class ValueExpressionAnalayserImpl
implements ValueExpressionAnalayser {
    private void checkNotNull(FacesContext context, ValueExpression expression) {
        if (context == null) {
            throw new NullPointerException("facesContext");
        }
        if (expression == null) {
            throw new NullPointerException("expression");
        }
    }

    private void resolveValue(FacesContext context, ValueExpression initialExpression, ValueResolutionCommand command) throws ELException {
        this.checkNotNull(context, initialExpression);
        ValueExpression expression = initialExpression;
        while (expression != null) {
            CapturingELContext capturingContext = new CapturingELContext(context.getELContext(), GraphValidatorState.getStateMap((FacesContext)context));
            command.resolve(expression, capturingContext);
            if (capturingContext.hasReferenceExpression()) {
                expression = capturingContext.getReferenceExpression();
                continue;
            }
            ValueDescriptor result = capturingContext.getDescriptor();
            if (result == null) {
                throw new ELException("Cannot determine property for expression " + initialExpression.getExpressionString());
            }
            command.setValueDescriptor(result);
            break;
        }
    }

    public ValueDescriptor getPropertyDescriptor(FacesContext context, ValueExpression expression) throws ELException {
        GetTypeCommand command = new GetTypeCommand();
        this.resolveValue(context, expression, command);
        return command.getValueDescriptor();
    }

    public ValueDescriptor updateValueAndGetPropertyDescriptor(FacesContext context, ValueExpression expression, Object newValue) throws ELException {
        SetValueCommand command = new SetValueCommand(newValue);
        this.resolveValue(context, expression, command);
        return command.getValueDescriptor();
    }

    private static final class SetValueCommand
    extends ValueResolutionCommand {
        private Object value;

        public SetValueCommand(Object value) {
            this.value = value;
        }

        @Override
        public void resolve(ValueExpression expression, ELContext context) {
            expression.setValue(context, this.value);
        }
    }

    private static final class GetTypeCommand
    extends ValueResolutionCommand {
        private GetTypeCommand() {
        }

        @Override
        public void resolve(ValueExpression expression, ELContext context) {
            expression.getType(context);
        }
    }

    private static abstract class ValueResolutionCommand {
        private ValueDescriptor valueDescriptor;

        private ValueResolutionCommand() {
        }

        public ValueDescriptor getValueDescriptor() {
            return this.valueDescriptor;
        }

        void setValueDescriptor(ValueDescriptor valueDescriptor) {
            this.valueDescriptor = valueDescriptor;
        }

        public abstract void resolve(ValueExpression var1, ELContext var2);
    }
}

