/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAttribute
implements Comparable<ComponentAttribute> {
    private final String htmlAttributeName;
    private String componentAttributeName;
    private Object defaultValue;
    private String[] eventNames = new String[0];
    private Kind kind = Kind.GENERIC;

    public ComponentAttribute(String htmlAttributeName) {
        this.htmlAttributeName = htmlAttributeName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object dafaultValue) {
        this.defaultValue = dafaultValue;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public static final Map<String, ComponentAttribute> createMap(ComponentAttribute ... attributes) {
        TreeMap<String, ComponentAttribute> result = new TreeMap<String, ComponentAttribute>();
        for (ComponentAttribute componentAttribute : attributes) {
            result.put(componentAttribute.getComponentAttributeName(), componentAttribute);
        }
        return result;
    }

    public String getHtmlAttributeName() {
        return this.htmlAttributeName;
    }

    public String getComponentAttributeName() {
        return this.componentAttributeName == null ? this.htmlAttributeName : this.componentAttributeName;
    }

    public ComponentAttribute setComponentAttributeName(String componentAttributeName) {
        this.componentAttributeName = componentAttributeName;
        return this;
    }

    public String[] getEventNames() {
        return this.eventNames;
    }

    public ComponentAttribute setEventNames(String ... eventNames) {
        this.eventNames = eventNames;
        return this;
    }

    @Override
    public int compareTo(ComponentAttribute o) {
        return this.getHtmlAttributeName().compareTo(o.getHtmlAttributeName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        BOOL,
        GENERIC,
        URI;

    }
}

