/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import com.google.common.collect.ImmutableSet;
import java.beans.FeatureDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.richfaces.el.ELContextWrapper;
import org.richfaces.el.ValueDescriptor;
import org.richfaces.el.ValueExpressionAnalayser;
import org.richfaces.validator.BeanValidatorDescriptor;
import org.richfaces.validator.BeanValidatorFactory;
import org.richfaces.validator.BeanValidatorService;
import org.richfaces.validator.ClonedObjectResolver;
import org.richfaces.validator.ValidatorDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidatorServiceImpl
implements BeanValidatorService {
    private static final Collection<String> HIDDEN_PARAMS = ImmutableSet.of((Object)"message", (Object)"payload", (Object)"groups");
    private static final String FACES_CONTEXT_IS_NULL = "Faces context is null";
    private static final String INPUT_PARAMETERS_IS_NOT_CORRECT = "Input parameters is not correct.";
    private static final Class<?>[] DEFAULT_GROUP = new Class[0];
    private final ValueExpressionAnalayser analayser;
    private final BeanValidatorFactory validatorFactory;

    public BeanValidatorServiceImpl(ValueExpressionAnalayser analayser, BeanValidatorFactory validatorFactory) {
        this.analayser = analayser;
        this.validatorFactory = validatorFactory;
    }

    public Collection<ValidatorDescriptor> getConstrains(FacesContext context, ValueExpression expression, Class<?> ... groups) {
        try {
            ValueDescriptor propertyDescriptor = this.analayser.getPropertyDescriptor(context, expression);
            return this.processBeanAttribute(context, propertyDescriptor, groups);
        }
        catch (ELException e) {
            return Collections.emptySet();
        }
    }

    private Validator getValidator(FacesContext context) {
        return this.validatorFactory.getValidator(context);
    }

    Collection<ValidatorDescriptor> processBeanAttribute(FacesContext context, ValueDescriptor descriptor, Class<?> ... groups) {
        PropertyDescriptor constraintsForProperty = this.getValidator(context).getConstraintsForClass(descriptor.getBeanType()).getConstraintsForProperty(descriptor.getName());
        if (null != constraintsForProperty) {
            ElementDescriptor.ConstraintFinder propertyConstraints = constraintsForProperty.findConstraints();
            if (null != groups && groups.length > 0) {
                propertyConstraints = propertyConstraints.unorderedAndMatchingGroups((Class[])groups);
            }
            Set constraints = propertyConstraints.getConstraintDescriptors();
            HashSet<ValidatorDescriptor> descriptors = new HashSet<ValidatorDescriptor>(constraints.size());
            this.processConstraints(context, constraints, descriptors);
            return descriptors;
        }
        return Collections.emptySet();
    }

    void processConstraints(FacesContext context, Set<ConstraintDescriptor<?>> constraints, Collection<ValidatorDescriptor> descriptors) {
        for (ConstraintDescriptor<?> cd : constraints) {
            Annotation a = cd.getAnnotation();
            Map parameters = cd.getAttributes();
            FacesMessage message = this.validatorFactory.interpolateMessage(context, cd);
            Class<? extends Annotation> validatorClass = this.findAnnotationClass(a);
            BeanValidatorDescriptor beanValidatorDescriptor = new BeanValidatorDescriptor(validatorClass, message);
            for (Map.Entry entry : parameters.entrySet()) {
                String key = (String)entry.getKey();
                if (HIDDEN_PARAMS.contains(key)) continue;
                Object value = entry.getValue();
                try {
                    Method method = validatorClass.getDeclaredMethod(key, new Class[0]);
                    Object defaultValue = method.getDefaultValue();
                    if (value.equals(defaultValue)) continue;
                    beanValidatorDescriptor.addParameter(key, value);
                }
                catch (SecurityException e) {
                    beanValidatorDescriptor.addParameter(key, value);
                }
                catch (NoSuchMethodException e) {
                    beanValidatorDescriptor.addParameter(key, value);
                }
            }
            beanValidatorDescriptor.makeImmutable();
            descriptors.add(beanValidatorDescriptor);
            this.processConstraints(context, cd.getComposingConstraints(), descriptors);
        }
    }

    private Class<? extends Annotation> findAnnotationClass(Annotation a) {
        Class<?> annotationClass = a.getClass();
        if (!annotationClass.isAnnotation()) {
            Class<?>[] interfaces;
            for (Class<?> implemented : interfaces = annotationClass.getInterfaces()) {
                if (!implemented.isAnnotation()) continue;
                annotationClass = implemented;
            }
        }
        return annotationClass;
    }

    public Collection<String> validateExpression(FacesContext context, ValueExpression expression, Object newValue, Class<?> ... groups) {
        if (null == context) {
            throw new FacesException(INPUT_PARAMETERS_IS_NOT_CORRECT);
        }
        Collection<String> validationMessages = Collections.emptySet();
        if (null != expression) {
            ELContext elContext = context.getELContext();
            ValidationResolver validationResolver = this.createValidationResolver(context, elContext.getELResolver(), groups);
            ELContextWrapper wrappedElContext = new ELContextWrapper(elContext, (ELResolver)validationResolver);
            try {
                expression.setValue((ELContext)wrappedElContext, newValue);
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            if (!validationResolver.isValid()) {
                validationMessages = validationResolver.getValidationMessages();
            }
        }
        return validationMessages;
    }

    protected ValidationResolver createValidationResolver(FacesContext context, ELResolver parent, Class<?>[] groups) {
        return new ValidationResolver(parent, context, groups);
    }

    protected Collection<String> validate(FacesContext facesContext, Object base, String property, Object value, Class<?>[] groups) {
        Class<?> beanType = base.getClass();
        Set constrains = this.getValidator(facesContext).validateValue(beanType, property, value, (Class[])this.getGroups(groups));
        return this.extractMessages(constrains);
    }

    private Class<?>[] getGroups(Class<?>[] groups) {
        return null == groups ? DEFAULT_GROUP : groups;
    }

    public Collection<String> validateObject(FacesContext context, Object value, Class<?> ... groups) {
        Set violations = this.getValidator(context).validate(value, (Class[])this.getGroups(groups));
        Collection<String> messages = this.extractMessages(violations);
        return messages;
    }

    private Collection<String> extractMessages(Set<ConstraintViolation<Object>> violations) {
        Collection<String> messages;
        if (null != violations && violations.size() > 0) {
            messages = new ArrayList(violations.size());
            for (ConstraintViolation<Object> constraintViolation : violations) {
                messages.add(constraintViolation.getMessage());
            }
        } else {
            messages = Collections.emptySet();
        }
        return messages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValidationResolver
    extends ELResolver {
        private final ELResolver parent;
        private boolean valid = true;
        private Collection<String> validationMessages = null;
        private Stack<BasePropertyPair> valuesStack;
        private Class<?>[] groups;
        private FacesContext facesContext;
        private boolean clonedObject = false;

        public ValidationResolver(ELResolver parent, FacesContext context, Class<?>[] groups) {
            this.parent = parent;
            this.valuesStack = new Stack();
            this.groups = groups;
            this.facesContext = context;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return this.parent.getCommonPropertyType(context, base);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return this.parent.getFeatureDescriptors(context, base);
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            return this.parent.getType(context, base, property);
        }

        public Object getValue(ELContext context, Object base, Object property) {
            Object value = ClonedObjectResolver.resolveCloned(context, base, property);
            if (null != value) {
                this.clonedObject = true;
                context.setPropertyResolved(true);
            } else {
                value = this.parent.getValue(context, base, property);
            }
            this.valuesStack.push(new BasePropertyPair(base, property));
            return value;
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return this.parent.isReadOnly(context, base, property);
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (null != base && null != property) {
                if (this.clonedObject) {
                    this.parent.setValue(context, base, property, value);
                }
                context.setPropertyResolved(true);
                BasePropertyPair basePropertyPair = this.lookupBeanProperty(new BasePropertyPair(base, property));
                base = basePropertyPair.getBase();
                property = basePropertyPair.getProperty();
                if (null != base && null != property) {
                    this.validationMessages = BeanValidatorServiceImpl.this.validate(this.facesContext, base, property.toString(), value, this.groups);
                    this.valid = null == this.validationMessages || 0 == this.validationMessages.size();
                }
            }
        }

        private BasePropertyPair lookupBeanProperty(BasePropertyPair pair) {
            Object base = pair.getBase();
            if (null != base && (base instanceof Collection || base instanceof Map || base.getClass().isArray())) {
                try {
                    pair = this.lookupBeanProperty(this.valuesStack.pop());
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
            return pair;
        }

        public Collection<String> getValidationMessages() {
            return this.validationMessages;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ValidatorKey {
        private final Class<? extends Object> validatableClass;
        private final Locale locale;

        public ValidatorKey(Class<? extends Object> validatableClass, Locale locale) {
            this.validatableClass = validatableClass;
            this.locale = locale;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.validatableClass == null ? 0 : this.validatableClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidatorKey other = (ValidatorKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.validatableClass == null ? other.validatableClass != null : !this.validatableClass.equals(other.validatableClass));
        }
    }

    protected static class BasePropertyPair {
        private final Object base;
        private final Object property;

        public BasePropertyPair(Object base, Object property) {
            this.base = base;
            this.property = property;
        }

        public Object getBase() {
            return this.base;
        }

        public Object getProperty() {
            return this.property;
        }
    }
}

