/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractToolbar;
import org.richfaces.component.AbstractToolbarGroup;
import org.richfaces.renderkit.html.ToolbarRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarGroupRenderer
extends ToolbarRendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.ToolbarGroupRenderer";

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractToolbarGroup.class;
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractToolbarGroup toolbarGroup = (AbstractToolbarGroup)component;
        List<UIComponent> renderedChildren = toolbarGroup.getRenderedChildren();
        if (renderedChildren.size() <= 0) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        this.renderChild(facesContext, toolbarGroup, writer, renderedChildren.get(0));
        for (int i = 1; i < renderedChildren.size(); ++i) {
            this.insertSeparatorIfNeed(facesContext, (UIComponent)toolbarGroup, writer);
            this.renderChild(facesContext, toolbarGroup, writer, renderedChildren.get(i));
        }
    }

    private void renderChild(FacesContext facesContext, AbstractToolbarGroup toolbarGroup, ResponseWriter writer, UIComponent child) throws IOException {
        writer.startElement("td", (UIComponent)toolbarGroup);
        writer.writeAttribute("id", (Object)this.encodeClientItemID(child), null);
        this.writeClassValue(toolbarGroup, writer);
        this.writeStyleValue(toolbarGroup, writer);
        child.encodeAll(facesContext);
        writer.endElement("td");
    }

    private void writeStyleValue(AbstractToolbarGroup toolbarGroup, ResponseWriter writer) throws IOException {
        String style = this.getStringAttribute((UIComponent)toolbarGroup, "style");
        String toolbarStyle = this.getStringAttribute((UIComponent)this.getParentToolBar((UIComponent)toolbarGroup), "itemStyle");
        String tooolbarGroupStyle = this.getStringAttribute((UIComponent)toolbarGroup, "itemStyle");
        String value = tooolbarGroupStyle != null && !tooolbarGroupStyle.equals("") ? this.concatStyles(tooolbarGroupStyle, style) : this.concatStyles(toolbarStyle, style);
        if (this.isPropertyRendered(value)) {
            writer.writeAttribute("style", (Object)value, null);
        }
    }

    private void writeClassValue(AbstractToolbarGroup toolbarGroup, ResponseWriter writer) throws IOException {
        String styleClass = this.getStringAttribute((UIComponent)toolbarGroup, "styleClass");
        String toolbarClass = this.getStringAttribute((UIComponent)this.getParentToolBar((UIComponent)toolbarGroup), "itemClass");
        String toolbarGroupClass = this.getStringAttribute((UIComponent)toolbarGroup, "itemClass");
        String itemClass = toolbarGroupClass != null && !toolbarGroupClass.equals("") ? toolbarGroupClass : toolbarClass;
        writer.writeAttribute("class", (Object)this.concatClasses("rf-tb-itm", itemClass, styleClass), null);
    }

    private String getStringAttribute(UIComponent toolbarGroup, String attribute) {
        String value = (String)toolbarGroup.getAttributes().get(attribute);
        return null == value ? "" : value;
    }

    public AbstractToolbar getParentToolBar(UIComponent component) {
        return component instanceof AbstractToolbarGroup ? ((AbstractToolbarGroup)component).getToolBar() : null;
    }
}

