/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.operator;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.operator.Operator;
import org.planx.xpath.object.XBoolean;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XObject;
import org.planx.xpath.object.XSimple;
import org.planx.xpath.object.XString;

public abstract class RelationalOperator
extends Operator {
    public RelationalOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    @Override
    protected XObject evaluate(XObject o1, XObject o2, Navigator navigator) throws XPathException {
        boolean result;
        if (o1 instanceof XNodeSet && o2 instanceof XNodeSet) {
            result = this.compare((XNodeSet)o1, (XNodeSet)o2, navigator);
        } else if (o1 instanceof XNodeSet && o2 instanceof XSimple) {
            XSimple v2 = (XSimple)o2;
            result = this.compare((XNodeSet)o1, v2.doubleValue(), navigator, false);
        } else if (o1 instanceof XSimple && o2 instanceof XNodeSet) {
            XSimple v1 = (XSimple)o1;
            result = this.compare((XNodeSet)o2, v1.doubleValue(), navigator, true);
        } else if (o1 instanceof XSimple && o2 instanceof XSimple) {
            XSimple v1 = (XSimple)o1;
            XSimple v2 = (XSimple)o2;
            result = this.compare(v1.doubleValue(), v2.doubleValue());
        } else {
            throw new XPathException("Unsupported subclass of XObject");
        }
        return result ? XBoolean.TRUE : XBoolean.FALSE;
    }

    private boolean compare(XNodeSet o1, XNodeSet o2, Navigator navigator) throws XPathException {
        double v;
        int i;
        double v1_min = Double.MAX_VALUE;
        double v1_max = Double.MIN_VALUE;
        double v2_min = Double.MAX_VALUE;
        double v2_max = Double.MIN_VALUE;
        int size = o1.size();
        for (i = 0; i < size; ++i) {
            v = XString.doubleValue(navigator.getStringValue(o1.get(i)));
            if (v < v1_min) {
                v1_min = v;
            }
            if (!(v > v1_max)) continue;
            v1_max = v;
        }
        size = o2.size();
        for (i = 0; i < size; ++i) {
            v = XString.doubleValue(navigator.getStringValue(o2.get(i)));
            if (v < v2_min) {
                v2_min = v;
            }
            if (!(v > v2_max)) continue;
            v2_max = v;
        }
        return this.compareSets(v1_min, v1_max, v2_min, v2_max);
    }

    protected abstract boolean compareSets(double var1, double var3, double var5, double var7);

    private boolean compare(XNodeSet o1, double v2, Navigator navigator, boolean flip) throws XPathException {
        int size = o1.size();
        for (int i = 0; i < size; ++i) {
            Object node = o1.get(i);
            double v1 = XString.doubleValue(navigator.getStringValue(node));
            if (!(flip ? this.compare(v2, v1) : this.compare(v1, v2))) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean compare(double var1, double var3);
}

