/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class FollowingSiblingAxis
extends Axis {
    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new FollowingSiblingAxisIterator(contextNode, navigator);
    }

    @Override
    public int getPrincipalNodeType() {
        return 2;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "following-sibling";
    }

    class FollowingSiblingAxisIterator
    implements AxisIterator {
        private Object currentNode = null;
        private Navigator navigator;
        private XPathException currentException = null;

        FollowingSiblingAxisIterator(Object contextNode, Navigator navigator) throws XPathException {
            this.navigator = navigator;
            int type = navigator.getType(contextNode);
            if (type != 4) {
                this.currentNode = contextNode;
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public Object next() throws XPathException {
            if (this.currentException != null) {
                throw this.currentException;
            }
            if (this.currentNode == null) {
                throw new XPathException("No more elements in iterator");
            }
            Object result = this.currentNode;
            try {
                this.currentNode = this.navigator.nextSibling(this.currentNode);
            }
            catch (XPathException e) {
                this.currentException = e;
                this.currentNode = null;
            }
            return result;
        }
    }
}

